; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -march=amdgcn -mcpu=gfx1100 < %s | FileCheck --check-prefixes=DEFAULT %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-waitcnt-load-forcezero < %s | FileCheck --check-prefixes=LDZERO %s

define amdgpu_kernel void @copy(ptr addrspace(1) noalias nocapture readonly %src1, ptr addrspace(1) noalias nocapture readonly %src2, ptr addrspace(1) noalias nocapture writeonly %dst1, ptr addrspace(1) noalias nocapture writeonly %dst2) {
; DEFAULT-LABEL: copy:
; DEFAULT:       ; %bb.0:
; DEFAULT-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; DEFAULT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; DEFAULT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; DEFAULT-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; DEFAULT-NEXT:    s_waitcnt lgkmcnt(0)
; DEFAULT-NEXT:    s_clause 0x1
; DEFAULT-NEXT:    global_load_b32 v1, v0, s[0:1]
; DEFAULT-NEXT:    global_load_b32 v2, v0, s[2:3]
; DEFAULT-NEXT:    s_waitcnt vmcnt(1)
; DEFAULT-NEXT:    global_store_b32 v0, v1, s[4:5]
; DEFAULT-NEXT:    s_waitcnt vmcnt(0)
; DEFAULT-NEXT:    global_store_b32 v0, v2, s[6:7]
; DEFAULT-NEXT:    s_endpgm
;
; LDZERO-LABEL: copy:
; LDZERO:       ; %bb.0:
; LDZERO-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; LDZERO-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; LDZERO-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; LDZERO-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; LDZERO-NEXT:    s_waitcnt lgkmcnt(0)
; LDZERO-NEXT:    s_clause 0x1
; LDZERO-NEXT:    global_load_b32 v1, v0, s[0:1]
; LDZERO-NEXT:    global_load_b32 v2, v0, s[2:3]
; LDZERO-NEXT:    s_waitcnt vmcnt(0)
; LDZERO-NEXT:    s_clause 0x1
; LDZERO-NEXT:    global_store_b32 v0, v1, s[4:5]
; LDZERO-NEXT:    global_store_b32 v0, v2, s[6:7]
; LDZERO-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %idx = zext i32 %id to i64
  %gep.ld1 = getelementptr inbounds nuw float, ptr addrspace(1) %src1, i64 %idx
  %v1 = load float, ptr addrspace(1) %gep.ld1, align 4
  %gep.ld2 = getelementptr inbounds nuw float, ptr addrspace(1) %src2, i64 %idx
  %v2 = load float, ptr addrspace(1) %gep.ld2, align 4
  %gep.st1 = getelementptr inbounds nuw float, ptr addrspace(1) %dst1, i64 %idx
  store float %v1, ptr addrspace(1) %gep.st1, align 4
  %gep.st2 = getelementptr inbounds nuw float, ptr addrspace(1) %dst2, i64 %idx
  store float %v2, ptr addrspace(1) %gep.st2, align 4
  ret void
}
