; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=avx512fp16,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512fp16,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512fp16 -O3 | FileCheck %s --check-prefixes=NOVL

declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f16(<2 x half>, metadata)
declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f16(<2 x half>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f16(<2 x half>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f16(<2 x half>, metadata)
declare <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f16(<2 x half>, metadata)
declare <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f16(<2 x half>, metadata)
declare <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f16(<2 x half>, metadata)
declare <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f16(<2 x half>, metadata)
declare <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f16(<2 x half>, metadata)
declare <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f16(<2 x half>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f16(<4 x half>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f16(<4 x half>, metadata)
declare <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f16(<4 x half>, metadata)
declare <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f16(<4 x half>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f16(<4 x half>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f16(<4 x half>, metadata)
declare <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f16(<4 x half>, metadata)
declare <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f16(<4 x half>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f16(<8 x half>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f16(<8 x half>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f16(<8 x half>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f16(<8 x half>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f16(<8 x half>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f16(<8 x half>, metadata)

define <2 x i64> @strict_vector_fptosi_v2f16_to_v2i64(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2qq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v2f16_to_v2i64:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttsh2si %xmm0, %rax
; NOVL-NEXT:    vmovq %rax, %xmm1
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %rax
; NOVL-NEXT:    vmovq %rax, %xmm0
; NOVL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; NOVL-NEXT:    retq
  %ret = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i64> %ret
}

define <2 x i64> @strict_vector_fptoui_v2f16_to_v2i64(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uqq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v2f16_to_v2i64:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttsh2usi %xmm0, %rax
; NOVL-NEXT:    vmovq %rax, %xmm1
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2usi %xmm0, %rax
; NOVL-NEXT:    vmovq %rax, %xmm0
; NOVL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; NOVL-NEXT:    retq
  %ret = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i64> %ret
}

define <2 x i32> @strict_vector_fptosi_v2f16_to_v2i32(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2dq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v2f16_to_v2i32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm0
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i32> %ret
}

define <2 x i32> @strict_vector_fptoui_v2f16_to_v2i32(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v2f16_to_v2i32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2usi %xmm1, %eax
; NOVL-NEXT:    vcvttsh2usi %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm0
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i32> %ret
}

define <2 x i16> @strict_vector_fptosi_v2f16_to_v2i16(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v2f16_to_v2i16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm0
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; NOVL-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i16> %ret
}

define <2 x i16> @strict_vector_fptoui_v2f16_to_v2i16(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v2f16_to_v2i16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm0
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; NOVL-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i16> %ret
}

define <2 x i8> @strict_vector_fptosi_v2f16_to_v2i8(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v2f16_to_v2i8:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm0
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; NOVL-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i8> %ret
}

define <2 x i8> @strict_vector_fptoui_v2f16_to_v2i8(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v2f16_to_v2i8:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm0
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; NOVL-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i8> %ret
}

define <2 x i1> @strict_vector_fptosi_v2f16_to_v2i1(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k1
; CHECK-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v2f16_to_v2i1:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    andl $1, %eax
; NOVL-NEXT:    kmovw %eax, %k0
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $1, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k1
; NOVL-NEXT:    vpternlogq {{.*#+}} zmm0 {%k1} {z} = -1
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i1> %ret
}

define <2 x i1> @strict_vector_fptoui_v2f16_to_v2i1(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k1
; CHECK-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v2f16_to_v2i1:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    andl $1, %eax
; NOVL-NEXT:    kmovw %eax, %k0
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $1, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k1
; NOVL-NEXT:    vpternlogq {{.*#+}} zmm0 {%k1} {z} = -1
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i1> %ret
}

define <4 x i32> @strict_vector_fptosi_v4f16_to_v4i32(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2dq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v4f16_to_v4i32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm1
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm2, %eax
; NOVL-NEXT:    vpinsrd $2, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm0
; NOVL-NEXT:    retq
  %ret = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i32> %ret
}

define <4 x i32> @strict_vector_fptoui_v4f16_to_v4i32(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v4f16_to_v4i32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2usi %xmm1, %eax
; NOVL-NEXT:    vcvttsh2usi %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm1
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2usi %xmm2, %eax
; NOVL-NEXT:    vpinsrd $2, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2usi %xmm0, %eax
; NOVL-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm0
; NOVL-NEXT:    retq
  %ret = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i32> %ret
}

define <4 x i16> @strict_vector_fptosi_v4f16_to_v4i16(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v4f16_to_v4i16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm1
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm2, %eax
; NOVL-NEXT:    vpinsrd $2, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm0
; NOVL-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i16> %ret
}

define <4 x i16> @strict_vector_fptoui_v4f16_to_v4i16(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v4f16_to_v4i16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm1
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm2, %eax
; NOVL-NEXT:    vpinsrd $2, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm0
; NOVL-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i16> %ret
}

define <4 x i8> @strict_vector_fptosi_v4f16_to_v4i8(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v4f16_to_v4i8:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm1
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm2, %eax
; NOVL-NEXT:    vpinsrd $2, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm0
; NOVL-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i8> %ret
}

define <4 x i8> @strict_vector_fptoui_v4f16_to_v4i8(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v4f16_to_v4i8:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    vcvttsh2si %xmm0, %ecx
; NOVL-NEXT:    vmovd %ecx, %xmm1
; NOVL-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm2, %eax
; NOVL-NEXT:    vpinsrd $2, %eax, %xmm1, %xmm1
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm0
; NOVL-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    retq
  %ret = call <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i8> %ret
}

define <4 x i1> @strict_vector_fptosi_v4f16_to_v4i1(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k1
; CHECK-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v4f16_to_v4i1:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    andl $1, %eax
; NOVL-NEXT:    kmovw %eax, %k0
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $15, %k1, %k1
; NOVL-NEXT:    kshiftrw $14, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k0
; NOVL-NEXT:    movw $-5, %ax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kandw %k1, %k0, %k0
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $2, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k0
; NOVL-NEXT:    kshiftlw $13, %k0, %k0
; NOVL-NEXT:    kshiftrw $13, %k0, %k0
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $3, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k1
; NOVL-NEXT:    vpternlogd {{.*#+}} zmm0 {%k1} {z} = -1
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i1> %ret
}

define <4 x i1> @strict_vector_fptoui_v4f16_to_v4i1(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k1
; CHECK-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v4f16_to_v4i1:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    andl $1, %eax
; NOVL-NEXT:    kmovw %eax, %k0
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm1
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $15, %k1, %k1
; NOVL-NEXT:    kshiftrw $14, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k0
; NOVL-NEXT:    movw $-5, %ax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kandw %k1, %k0, %k0
; NOVL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; NOVL-NEXT:    vcvttsh2si %xmm1, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $2, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k0
; NOVL-NEXT:    kshiftlw $13, %k0, %k0
; NOVL-NEXT:    kshiftrw $13, %k0, %k0
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; NOVL-NEXT:    vcvttsh2si %xmm0, %eax
; NOVL-NEXT:    kmovd %eax, %k1
; NOVL-NEXT:    kshiftlw $3, %k1, %k1
; NOVL-NEXT:    korw %k1, %k0, %k1
; NOVL-NEXT:    vpternlogd {{.*#+}} zmm0 {%k1} {z} = -1
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i1> %ret
}

define <8 x i16> @strict_vector_fptosi_v8f16_to_v8i16(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v8f16_to_v8i16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vinsertf32x4 $0, %xmm0, %zmm1, %zmm0
; NOVL-NEXT:    vcvttph2w %zmm0, %zmm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i16> @strict_vector_fptoui_v8f16_to_v8i16(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v8f16_to_v8i16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vinsertf32x4 $0, %xmm0, %zmm1, %zmm0
; NOVL-NEXT:    vcvttph2uw %zmm0, %zmm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i8> @strict_vector_fptosi_v8f16_to_v8i8(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v8f16_to_v8i8:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vinsertf32x4 $0, %xmm0, %zmm1, %zmm0
; NOVL-NEXT:    vcvttph2w %zmm0, %zmm0
; NOVL-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i8> @strict_vector_fptoui_v8f16_to_v8i8(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v8f16_to_v8i8:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vinsertf32x4 $0, %xmm0, %zmm1, %zmm0
; NOVL-NEXT:    vcvttph2w %zmm0, %zmm0
; NOVL-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i1> @strict_vector_fptosi_v8f16_to_v8i1(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2dq %xmm0, %ymm0
; CHECK-NEXT:    vptestmd %ymm0, %ymm0, %k0
; CHECK-NEXT:    vpmovm2w %k0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptosi_v8f16_to_v8i1:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; NOVL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; NOVL-NEXT:    vcvttph2dq %ymm0, %zmm0
; NOVL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; NOVL-NEXT:    vpmovm2w %k0, %zmm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

define <8 x i1> @strict_vector_fptoui_v8f16_to_v8i1(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2dq %xmm0, %ymm0
; CHECK-NEXT:    vpslld $31, %ymm0, %ymm0
; CHECK-NEXT:    vptestmd %ymm0, %ymm0, %k0
; CHECK-NEXT:    vpmovm2w %k0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
;
; NOVL-LABEL: strict_vector_fptoui_v8f16_to_v8i1:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; NOVL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; NOVL-NEXT:    vcvttph2dq %ymm0, %zmm0
; NOVL-NEXT:    vpslld $31, %ymm0, %ymm0
; NOVL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; NOVL-NEXT:    vpmovm2w %k0, %zmm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
  %ret = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

attributes #0 = { strictfp }
