; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=riscv32 -mattr=+v -verify-machineinstrs | FileCheck -check-prefix=VLA %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v -verify-machineinstrs | FileCheck -check-prefix=VLA %s

; RUN: llc < %s -mtriple=riscv32 -mattr=+v -riscv-v-vector-bits-max=128 -verify-machineinstrs | FileCheck -check-prefix=VLS %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v -riscv-v-vector-bits-max=128 -verify-machineinstrs | FileCheck -check-prefix=VLS %s

define <8 x i32> @concat_2xv4i32(<4 x i32> %a, <4 x i32> %b) {
; VLA-LABEL: concat_2xv4i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; VLA-NEXT:    vmv1r.v v10, v9
; VLA-NEXT:    vslideup.vi v8, v10, 4
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_2xv4i32:
; VLS:       # %bb.0:
; VLS-NEXT:    ret
  %ab = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %ab
}

define <8 x i32> @concat_4xv2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i32> %d) {
; VLA-LABEL: concat_4xv2i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLA-NEXT:    vslideup.vi v10, v11, 2
; VLA-NEXT:    vslideup.vi v8, v9, 2
; VLA-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; VLA-NEXT:    vslideup.vi v8, v10, 4
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_4xv2i32:
; VLS:       # %bb.0:
; VLS-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLS-NEXT:    vmv1r.v v13, v10
; VLS-NEXT:    vmv1r.v v12, v8
; VLS-NEXT:    vslideup.vi v13, v11, 2
; VLS-NEXT:    vslideup.vi v12, v9, 2
; VLS-NEXT:    vmv2r.v v8, v12
; VLS-NEXT:    ret
  %ab = shufflevector <2 x i32> %a, <2 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cd = shufflevector <2 x i32> %c, <2 x i32> %d, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %abcd = shufflevector <4 x i32> %ab, <4 x i32> %cd, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %abcd
}

define <8 x i32> @concat_8xv1i32(<1 x i32> %a, <1 x i32> %b, <1 x i32> %c, <1 x i32> %d, <1 x i32> %e, <1 x i32> %f, <1 x i32> %g, <1 x i32> %h) {
; VLA-LABEL: concat_8xv1i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; VLA-NEXT:    vslideup.vi v14, v15, 1
; VLA-NEXT:    vslideup.vi v12, v13, 1
; VLA-NEXT:    vslideup.vi v10, v11, 1
; VLA-NEXT:    vslideup.vi v8, v9, 1
; VLA-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLA-NEXT:    vslideup.vi v12, v14, 2
; VLA-NEXT:    vslideup.vi v8, v10, 2
; VLA-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; VLA-NEXT:    vslideup.vi v8, v12, 4
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_8xv1i32:
; VLS:       # %bb.0:
; VLS-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; VLS-NEXT:    vmv1r.v v17, v12
; VLS-NEXT:    vmv1r.v v16, v8
; VLS-NEXT:    vslideup.vi v14, v15, 1
; VLS-NEXT:    vslideup.vi v17, v13, 1
; VLS-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLS-NEXT:    vslideup.vi v17, v14, 2
; VLS-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; VLS-NEXT:    vslideup.vi v10, v11, 1
; VLS-NEXT:    vslideup.vi v16, v9, 1
; VLS-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLS-NEXT:    vslideup.vi v16, v10, 2
; VLS-NEXT:    vmv2r.v v8, v16
; VLS-NEXT:    ret
  %ab = shufflevector <1 x i32> %a, <1 x i32> %b, <2 x i32> <i32 0, i32 1>
  %cd = shufflevector <1 x i32> %c, <1 x i32> %d, <2 x i32> <i32 0, i32 1>
  %abcd = shufflevector <2 x i32> %ab, <2 x i32> %cd, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %ef = shufflevector <1 x i32> %e, <1 x i32> %f, <2 x i32> <i32 0, i32 1>
  %gh = shufflevector <1 x i32> %g, <1 x i32> %h, <2 x i32> <i32 0, i32 1>
  %efgh = shufflevector <2 x i32> %ef, <2 x i32> %gh, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %abcdefgh = shufflevector <4 x i32> %abcd, <4 x i32> %efgh, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %abcdefgh
}

define <16 x i32> @concat_2xv8i32(<8 x i32> %a, <8 x i32> %b) {
; VLA-LABEL: concat_2xv8i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; VLA-NEXT:    vmv2r.v v12, v10
; VLA-NEXT:    vslideup.vi v8, v12, 8
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_2xv8i32:
; VLS:       # %bb.0:
; VLS-NEXT:    ret
  %v = shufflevector <8 x i32> %a, <8 x i32> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i32> %v
}

define <16 x i32> @concat_4xv4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i32> %d) {
; VLA-LABEL: concat_4xv4i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; VLA-NEXT:    vmv1r.v v14, v11
; VLA-NEXT:    vmv1r.v v12, v10
; VLA-NEXT:    vmv1r.v v10, v9
; VLA-NEXT:    vslideup.vi v12, v14, 4
; VLA-NEXT:    vslideup.vi v8, v10, 4
; VLA-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; VLA-NEXT:    vslideup.vi v8, v12, 8
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_4xv4i32:
; VLS:       # %bb.0:
; VLS-NEXT:    ret
  %ab = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cd = shufflevector <4 x i32> %c, <4 x i32> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %abcd = shufflevector <8 x i32> %ab, <8 x i32> %cd, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i32> %abcd
}

define <16 x i32> @concat_8xv2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i32> %d, <2 x i32> %e, <2 x i32> %f, <2 x i32> %g, <2 x i32> %h) {
; VLA-LABEL: concat_8xv2i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLA-NEXT:    vslideup.vi v14, v15, 2
; VLA-NEXT:    vslideup.vi v12, v13, 2
; VLA-NEXT:    vslideup.vi v10, v11, 2
; VLA-NEXT:    vslideup.vi v8, v9, 2
; VLA-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; VLA-NEXT:    vslideup.vi v12, v14, 4
; VLA-NEXT:    vslideup.vi v8, v10, 4
; VLA-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; VLA-NEXT:    vslideup.vi v8, v12, 8
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_8xv2i32:
; VLS:       # %bb.0:
; VLS-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLS-NEXT:    vmv1r.v v19, v14
; VLS-NEXT:    vmv1r.v v18, v12
; VLS-NEXT:    vmv1r.v v17, v10
; VLS-NEXT:    vmv1r.v v16, v8
; VLS-NEXT:    vslideup.vi v19, v15, 2
; VLS-NEXT:    vslideup.vi v18, v13, 2
; VLS-NEXT:    vslideup.vi v17, v11, 2
; VLS-NEXT:    vslideup.vi v16, v9, 2
; VLS-NEXT:    vmv4r.v v8, v16
; VLS-NEXT:    ret
  %ab = shufflevector <2 x i32> %a, <2 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cd = shufflevector <2 x i32> %c, <2 x i32> %d, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %abcd = shufflevector <4 x i32> %ab, <4 x i32> %cd, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %ef = shufflevector <2 x i32> %e, <2 x i32> %f, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %gh = shufflevector <2 x i32> %g, <2 x i32> %h, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %efgh = shufflevector <4 x i32> %ef, <4 x i32> %gh, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %abcdefgh = shufflevector <8 x i32> %abcd, <8 x i32> %efgh, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i32> %abcdefgh
}

define <32 x i32> @concat_2xv16i32(<16 x i32> %a, <16 x i32> %b) {
; VLA-LABEL: concat_2xv16i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; VLA-NEXT:    vmv4r.v v16, v12
; VLA-NEXT:    li a0, 32
; VLA-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; VLA-NEXT:    vslideup.vi v8, v16, 16
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_2xv16i32:
; VLS:       # %bb.0:
; VLS-NEXT:    ret
  %ab = shufflevector <16 x i32> %a, <16 x i32> %b, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i32> %ab
}

define <32 x i32> @concat_4xv8i32(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i32> %d) {
; VLA-LABEL: concat_4xv8i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; VLA-NEXT:    vmv2r.v v20, v14
; VLA-NEXT:    vmv2r.v v16, v12
; VLA-NEXT:    vmv2r.v v12, v10
; VLA-NEXT:    li a0, 32
; VLA-NEXT:    vslideup.vi v16, v20, 8
; VLA-NEXT:    vslideup.vi v8, v12, 8
; VLA-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; VLA-NEXT:    vslideup.vi v8, v16, 16
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_4xv8i32:
; VLS:       # %bb.0:
; VLS-NEXT:    ret
  %ab = shufflevector <8 x i32> %a, <8 x i32> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %cd = shufflevector <8 x i32> %c, <8 x i32> %d, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %abcd = shufflevector <16 x i32> %ab, <16 x i32> %cd, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i32> %abcd
}

define <32 x i32> @concat_8xv4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i32> %d, <4 x i32> %e, <4 x i32> %f, <4 x i32> %g, <4 x i32> %h) {
; VLA-LABEL: concat_8xv4i32:
; VLA:       # %bb.0:
; VLA-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; VLA-NEXT:    vmv1r.v v18, v15
; VLA-NEXT:    vmv1r.v v20, v14
; VLA-NEXT:    vmv1r.v v14, v13
; VLA-NEXT:    vmv1r.v v16, v12
; VLA-NEXT:    vmv1r.v v22, v11
; VLA-NEXT:    vmv1r.v v12, v10
; VLA-NEXT:    vmv1r.v v10, v9
; VLA-NEXT:    li a0, 32
; VLA-NEXT:    vslideup.vi v20, v18, 4
; VLA-NEXT:    vslideup.vi v16, v14, 4
; VLA-NEXT:    vslideup.vi v12, v22, 4
; VLA-NEXT:    vslideup.vi v8, v10, 4
; VLA-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; VLA-NEXT:    vslideup.vi v16, v20, 8
; VLA-NEXT:    vslideup.vi v8, v12, 8
; VLA-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; VLA-NEXT:    vslideup.vi v8, v16, 16
; VLA-NEXT:    ret
;
; VLS-LABEL: concat_8xv4i32:
; VLS:       # %bb.0:
; VLS-NEXT:    ret
  %ab = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cd = shufflevector <4 x i32> %c, <4 x i32> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %abcd = shufflevector <8 x i32> %ab, <8 x i32> %cd, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %ef = shufflevector <4 x i32> %e, <4 x i32> %f, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %gh = shufflevector <4 x i32> %g, <4 x i32> %h, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %efgh = shufflevector <8 x i32> %ef, <8 x i32> %gh, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %abcdefgh = shufflevector <16 x i32> %abcd, <16 x i32> %efgh, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i32> %abcdefgh
}
