// RUN: llvm-mc -triple=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

v_pk_mad_i16 v5, v1, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v255, v1, v2, v3
// CHECK: [0xff,0x40,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v255, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0xff,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, s1, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, s101, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x65,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x66,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x67,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x6a,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x6b,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, ttmp15, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x7b,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, m0, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x7c,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x7e,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x7f,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, 0, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x80,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, -1, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0xc1,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0xfb,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, src_execz, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0xfc,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, src_scc, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0xfd,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0xfe,0x04,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v255, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xff,0x0f,0x1c]

v_pk_mad_i16 v5, v1, s2, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x0c,0x1c]

v_pk_mad_i16 v5, v1, s101, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xcb,0x0c,0x1c]

v_pk_mad_i16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xcd,0x0c,0x1c]

v_pk_mad_i16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xcf,0x0c,0x1c]

v_pk_mad_i16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xd5,0x0c,0x1c]

v_pk_mad_i16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xd7,0x0c,0x1c]

v_pk_mad_i16 v5, v1, ttmp15, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xf7,0x0c,0x1c]

v_pk_mad_i16 v5, v1, m0, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xf9,0x0c,0x1c]

v_pk_mad_i16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xfd,0x0c,0x1c]

v_pk_mad_i16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xff,0x0c,0x1c]

v_pk_mad_i16 v5, v1, 0, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x01,0x0d,0x1c]

v_pk_mad_i16 v5, v1, -1, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x83,0x0d,0x1c]

v_pk_mad_i16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xf7,0x0d,0x1c]

v_pk_mad_i16 v5, v1, src_execz, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xf9,0x0d,0x1c]

v_pk_mad_i16 v5, v1, src_scc, v3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0xfb,0x0d,0x1c]

v_pk_mad_i16 v5, v1, v2, v255
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xfe,0x1f]

v_pk_mad_i16 v5, v1, v2, s3
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x0e,0x18]

v_pk_mad_i16 v5, v1, v2, s101
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x96,0x19]

v_pk_mad_i16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x9a,0x19]

v_pk_mad_i16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x9e,0x19]

v_pk_mad_i16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xaa,0x19]

v_pk_mad_i16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xae,0x19]

v_pk_mad_i16 v5, v1, v2, ttmp15
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xee,0x19]

v_pk_mad_i16 v5, v1, v2, m0
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xf2,0x19]

v_pk_mad_i16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xfa,0x19]

v_pk_mad_i16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xfe,0x19]

v_pk_mad_i16 v5, v1, v2, 0
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x02,0x1a]

v_pk_mad_i16 v5, v1, v2, -1
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x06,0x1b]

v_pk_mad_i16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xee,0x1b]

v_pk_mad_i16 v5, v1, v2, src_execz
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xf2,0x1b]

v_pk_mad_i16 v5, v1, v2, src_scc
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0xf6,0x1b]

v_pk_mad_i16 v5, v1, v2, v3 op_sel:[0,0,0]
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel:[1,0,0]
// CHECK: [0x05,0x48,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel:[0,1,0]
// CHECK: [0x05,0x50,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel:[0,0,1]
// CHECK: [0x05,0x60,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel:[1,1,1]
// CHECK: [0x05,0x78,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel_hi:[1,1,1]
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel_hi:[0,0,0]
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x05,0x0e,0x04]

v_pk_mad_i16 v5, v1, v2, v3 op_sel_hi:[1,0,0]
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x05,0x0e,0x0c]

v_pk_mad_i16 v5, v1, v2, v3 op_sel_hi:[0,1,0]
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x05,0x0e,0x14]

v_pk_mad_i16 v5, v1, v2, v3 op_sel_hi:[0,0,1]
// CHECK: [0x05,0x40,0x80,0xd3,0x01,0x05,0x0e,0x04]

v_pk_mad_i16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0xc0,0x80,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mul_lo_u16 v5, v1, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v255, v1, v2
// CHECK: [0xff,0x40,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v255, v2
// CHECK: [0x05,0x40,0x81,0xd3,0xff,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, s1, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, s101, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x65,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x66,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x67,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x6a,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x6b,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x7b,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, m0, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x7c,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x7e,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x7f,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, 0, v2
// CHECK: [0x05,0x40,0x81,0xd3,0x80,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, -1, v2
// CHECK: [0x05,0x40,0x81,0xd3,0xc1,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x81,0xd3,0xfb,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x81,0xd3,0xfc,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x81,0xd3,0xfd,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x81,0xd3,0xfe,0x04,0x02,0x18]

v_pk_mul_lo_u16 v5, v1, v255
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xff,0x03,0x18]

v_pk_mul_lo_u16 v5, v1, s2
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, s101
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xcb,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xcd,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xcf,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xd5,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xd7,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xf7,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, m0
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xf9,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xfd,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xff,0x00,0x18]

v_pk_mul_lo_u16 v5, v1, 0
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x01,0x01,0x18]

v_pk_mul_lo_u16 v5, v1, -1
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x83,0x01,0x18]

v_pk_mul_lo_u16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xf7,0x01,0x18]

v_pk_mul_lo_u16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xf9,0x01,0x18]

v_pk_mul_lo_u16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0xfb,0x01,0x18]

v_pk_mul_lo_u16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x02,0x00]

v_pk_mul_lo_u16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x02,0x08]

v_pk_mul_lo_u16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x81,0xd3,0x01,0x05,0x02,0x10]

v_pk_add_i16 v5, v1, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v255, v1, v2
// CHECK: [0xff,0x40,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v255, v2
// CHECK: [0x05,0x40,0x82,0xd3,0xff,0x05,0x02,0x18]

v_pk_add_i16 v5, s1, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x04,0x02,0x18]

v_pk_add_i16 v5, s101, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x65,0x04,0x02,0x18]

v_pk_add_i16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x66,0x04,0x02,0x18]

v_pk_add_i16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x67,0x04,0x02,0x18]

v_pk_add_i16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x6a,0x04,0x02,0x18]

v_pk_add_i16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x6b,0x04,0x02,0x18]

v_pk_add_i16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x7b,0x04,0x02,0x18]

v_pk_add_i16 v5, m0, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x7c,0x04,0x02,0x18]

v_pk_add_i16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x7e,0x04,0x02,0x18]

v_pk_add_i16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x7f,0x04,0x02,0x18]

v_pk_add_i16 v5, 0, v2
// CHECK: [0x05,0x40,0x82,0xd3,0x80,0x04,0x02,0x18]

v_pk_add_i16 v5, -1, v2
// CHECK: [0x05,0x40,0x82,0xd3,0xc1,0x04,0x02,0x18]

v_pk_add_i16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x82,0xd3,0xfb,0x04,0x02,0x18]

v_pk_add_i16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x82,0xd3,0xfc,0x04,0x02,0x18]

v_pk_add_i16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x82,0xd3,0xfd,0x04,0x02,0x18]

v_pk_add_i16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x82,0xd3,0xfe,0x04,0x02,0x18]

v_pk_add_i16 v5, v1, v255
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xff,0x03,0x18]

v_pk_add_i16 v5, v1, s2
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x00,0x18]

v_pk_add_i16 v5, v1, s101
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xcb,0x00,0x18]

v_pk_add_i16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xcd,0x00,0x18]

v_pk_add_i16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xcf,0x00,0x18]

v_pk_add_i16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xd5,0x00,0x18]

v_pk_add_i16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xd7,0x00,0x18]

v_pk_add_i16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xf7,0x00,0x18]

v_pk_add_i16 v5, v1, m0
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xf9,0x00,0x18]

v_pk_add_i16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xfd,0x00,0x18]

v_pk_add_i16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xff,0x00,0x18]

v_pk_add_i16 v5, v1, 0
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x01,0x01,0x18]

v_pk_add_i16 v5, v1, -1
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x83,0x01,0x18]

v_pk_add_i16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xf7,0x01,0x18]

v_pk_add_i16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xf9,0x01,0x18]

v_pk_add_i16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0xfb,0x01,0x18]

v_pk_add_i16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x02,0x00]

v_pk_add_i16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x02,0x08]

v_pk_add_i16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x82,0xd3,0x01,0x05,0x02,0x10]

v_pk_add_i16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x82,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v1, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v255, v1, v2
// CHECK: [0xff,0x40,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v255, v2
// CHECK: [0x05,0x40,0x83,0xd3,0xff,0x05,0x02,0x18]

v_pk_sub_i16 v5, s1, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x04,0x02,0x18]

v_pk_sub_i16 v5, s101, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x65,0x04,0x02,0x18]

v_pk_sub_i16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x66,0x04,0x02,0x18]

v_pk_sub_i16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x67,0x04,0x02,0x18]

v_pk_sub_i16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x6a,0x04,0x02,0x18]

v_pk_sub_i16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x6b,0x04,0x02,0x18]

v_pk_sub_i16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x7b,0x04,0x02,0x18]

v_pk_sub_i16 v5, m0, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x7c,0x04,0x02,0x18]

v_pk_sub_i16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x7e,0x04,0x02,0x18]

v_pk_sub_i16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x7f,0x04,0x02,0x18]

v_pk_sub_i16 v5, 0, v2
// CHECK: [0x05,0x40,0x83,0xd3,0x80,0x04,0x02,0x18]

v_pk_sub_i16 v5, -1, v2
// CHECK: [0x05,0x40,0x83,0xd3,0xc1,0x04,0x02,0x18]

v_pk_sub_i16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x83,0xd3,0xfb,0x04,0x02,0x18]

v_pk_sub_i16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x83,0xd3,0xfc,0x04,0x02,0x18]

v_pk_sub_i16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x83,0xd3,0xfd,0x04,0x02,0x18]

v_pk_sub_i16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x83,0xd3,0xfe,0x04,0x02,0x18]

v_pk_sub_i16 v5, v1, v255
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xff,0x03,0x18]

v_pk_sub_i16 v5, v1, s2
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x00,0x18]

v_pk_sub_i16 v5, v1, s101
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xcb,0x00,0x18]

v_pk_sub_i16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xcd,0x00,0x18]

v_pk_sub_i16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xcf,0x00,0x18]

v_pk_sub_i16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xd5,0x00,0x18]

v_pk_sub_i16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xd7,0x00,0x18]

v_pk_sub_i16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xf7,0x00,0x18]

v_pk_sub_i16 v5, v1, m0
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xf9,0x00,0x18]

v_pk_sub_i16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xfd,0x00,0x18]

v_pk_sub_i16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xff,0x00,0x18]

v_pk_sub_i16 v5, v1, 0
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x01,0x01,0x18]

v_pk_sub_i16 v5, v1, -1
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x83,0x01,0x18]

v_pk_sub_i16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xf7,0x01,0x18]

v_pk_sub_i16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xf9,0x01,0x18]

v_pk_sub_i16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0xfb,0x01,0x18]

v_pk_sub_i16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x02,0x00]

v_pk_sub_i16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x02,0x08]

v_pk_sub_i16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x83,0xd3,0x01,0x05,0x02,0x10]

v_pk_sub_i16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x83,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v255, v1, v2
// CHECK: [0xff,0x40,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v255, v2
// CHECK: [0x05,0x40,0x84,0xd3,0xff,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, s1, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, s101, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x65,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x66,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x67,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x6a,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x6b,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x7b,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, m0, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x7c,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x7e,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x7f,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, 0, v2
// CHECK: [0x05,0x40,0x84,0xd3,0x80,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, -1, v2
// CHECK: [0x05,0x40,0x84,0xd3,0xc1,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x84,0xd3,0xfb,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x84,0xd3,0xfc,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x84,0xd3,0xfd,0x04,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v255
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xff,0x03,0x18]

v_pk_lshlrev_b16 v5, v1, s2
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, s101
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xcb,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xcd,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xcf,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xd5,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xd7,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xf7,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, m0
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xf9,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xfd,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xff,0x00,0x18]

v_pk_lshlrev_b16 v5, v1, 0
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x01,0x01,0x18]

v_pk_lshlrev_b16 v5, v1, -1
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x83,0x01,0x18]

v_pk_lshlrev_b16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xf7,0x01,0x18]

v_pk_lshlrev_b16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xf9,0x01,0x18]

v_pk_lshlrev_b16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0xfb,0x01,0x18]

v_pk_lshlrev_b16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x02,0x00]

v_pk_lshlrev_b16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x02,0x08]

v_pk_lshlrev_b16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x84,0xd3,0x01,0x05,0x02,0x10]

v_pk_lshrrev_b16 v5, v1, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v255, v1, v2
// CHECK: [0xff,0x40,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v255, v2
// CHECK: [0x05,0x40,0x85,0xd3,0xff,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, s1, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, s101, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x65,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x66,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x67,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x6a,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x6b,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x7b,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, m0, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x7c,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x7e,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x7f,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, 0, v2
// CHECK: [0x05,0x40,0x85,0xd3,0x80,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, -1, v2
// CHECK: [0x05,0x40,0x85,0xd3,0xc1,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x85,0xd3,0xfb,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x85,0xd3,0xfc,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x85,0xd3,0xfd,0x04,0x02,0x18]

v_pk_lshrrev_b16 v5, v1, v255
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xff,0x03,0x18]

v_pk_lshrrev_b16 v5, v1, s2
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, s101
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xcb,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xcd,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xcf,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xd5,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xd7,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xf7,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, m0
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xf9,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xfd,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xff,0x00,0x18]

v_pk_lshrrev_b16 v5, v1, 0
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x01,0x01,0x18]

v_pk_lshrrev_b16 v5, v1, -1
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x83,0x01,0x18]

v_pk_lshrrev_b16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xf7,0x01,0x18]

v_pk_lshrrev_b16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xf9,0x01,0x18]

v_pk_lshrrev_b16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0xfb,0x01,0x18]

v_pk_lshrrev_b16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x02,0x00]

v_pk_lshrrev_b16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x02,0x08]

v_pk_lshrrev_b16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x85,0xd3,0x01,0x05,0x02,0x10]

v_pk_ashrrev_i16 v5, v1, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v255, v1, v2
// CHECK: [0xff,0x40,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v255, v2
// CHECK: [0x05,0x40,0x86,0xd3,0xff,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, s1, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, s101, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x65,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x66,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x67,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x6a,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x6b,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x7b,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, m0, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x7c,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x7e,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x7f,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, 0, v2
// CHECK: [0x05,0x40,0x86,0xd3,0x80,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, -1, v2
// CHECK: [0x05,0x40,0x86,0xd3,0xc1,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x86,0xd3,0xfb,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x86,0xd3,0xfc,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x86,0xd3,0xfd,0x04,0x02,0x18]

v_pk_ashrrev_i16 v5, v1, v255
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xff,0x03,0x18]

v_pk_ashrrev_i16 v5, v1, s2
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, s101
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xcb,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xcd,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xcf,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xd5,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xd7,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xf7,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, m0
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xf9,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xfd,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xff,0x00,0x18]

v_pk_ashrrev_i16 v5, v1, 0
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x01,0x01,0x18]

v_pk_ashrrev_i16 v5, v1, -1
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x83,0x01,0x18]

v_pk_ashrrev_i16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xf7,0x01,0x18]

v_pk_ashrrev_i16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xf9,0x01,0x18]

v_pk_ashrrev_i16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0xfb,0x01,0x18]

v_pk_ashrrev_i16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x02,0x00]

v_pk_ashrrev_i16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x02,0x08]

v_pk_ashrrev_i16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x86,0xd3,0x01,0x05,0x02,0x10]

v_pk_max_i16 v5, v1, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v255, v1, v2
// CHECK: [0xff,0x40,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v255, v2
// CHECK: [0x05,0x40,0x87,0xd3,0xff,0x05,0x02,0x18]

v_pk_max_i16 v5, s1, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x04,0x02,0x18]

v_pk_max_i16 v5, s101, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x65,0x04,0x02,0x18]

v_pk_max_i16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x66,0x04,0x02,0x18]

v_pk_max_i16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x67,0x04,0x02,0x18]

v_pk_max_i16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x6a,0x04,0x02,0x18]

v_pk_max_i16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x6b,0x04,0x02,0x18]

v_pk_max_i16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x7b,0x04,0x02,0x18]

v_pk_max_i16 v5, m0, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x7c,0x04,0x02,0x18]

v_pk_max_i16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x7e,0x04,0x02,0x18]

v_pk_max_i16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x7f,0x04,0x02,0x18]

v_pk_max_i16 v5, 0, v2
// CHECK: [0x05,0x40,0x87,0xd3,0x80,0x04,0x02,0x18]

v_pk_max_i16 v5, -1, v2
// CHECK: [0x05,0x40,0x87,0xd3,0xc1,0x04,0x02,0x18]

v_pk_max_i16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x87,0xd3,0xfb,0x04,0x02,0x18]

v_pk_max_i16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x87,0xd3,0xfc,0x04,0x02,0x18]

v_pk_max_i16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x87,0xd3,0xfd,0x04,0x02,0x18]

v_pk_max_i16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x87,0xd3,0xfe,0x04,0x02,0x18]

v_pk_max_i16 v5, v1, v255
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xff,0x03,0x18]

v_pk_max_i16 v5, v1, s2
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x00,0x18]

v_pk_max_i16 v5, v1, s101
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xcb,0x00,0x18]

v_pk_max_i16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xcd,0x00,0x18]

v_pk_max_i16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xcf,0x00,0x18]

v_pk_max_i16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xd5,0x00,0x18]

v_pk_max_i16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xd7,0x00,0x18]

v_pk_max_i16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xf7,0x00,0x18]

v_pk_max_i16 v5, v1, m0
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xf9,0x00,0x18]

v_pk_max_i16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xfd,0x00,0x18]

v_pk_max_i16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xff,0x00,0x18]

v_pk_max_i16 v5, v1, 0
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x01,0x01,0x18]

v_pk_max_i16 v5, v1, -1
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x83,0x01,0x18]

v_pk_max_i16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xf7,0x01,0x18]

v_pk_max_i16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xf9,0x01,0x18]

v_pk_max_i16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0xfb,0x01,0x18]

v_pk_max_i16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x02,0x00]

v_pk_max_i16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x02,0x08]

v_pk_max_i16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x87,0xd3,0x01,0x05,0x02,0x10]

v_pk_min_i16 v5, v1, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v255, v1, v2
// CHECK: [0xff,0x40,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v255, v2
// CHECK: [0x05,0x40,0x88,0xd3,0xff,0x05,0x02,0x18]

v_pk_min_i16 v5, s1, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x04,0x02,0x18]

v_pk_min_i16 v5, s101, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x65,0x04,0x02,0x18]

v_pk_min_i16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x66,0x04,0x02,0x18]

v_pk_min_i16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x67,0x04,0x02,0x18]

v_pk_min_i16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x6a,0x04,0x02,0x18]

v_pk_min_i16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x6b,0x04,0x02,0x18]

v_pk_min_i16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x7b,0x04,0x02,0x18]

v_pk_min_i16 v5, m0, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x7c,0x04,0x02,0x18]

v_pk_min_i16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x7e,0x04,0x02,0x18]

v_pk_min_i16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x7f,0x04,0x02,0x18]

v_pk_min_i16 v5, 0, v2
// CHECK: [0x05,0x40,0x88,0xd3,0x80,0x04,0x02,0x18]

v_pk_min_i16 v5, -1, v2
// CHECK: [0x05,0x40,0x88,0xd3,0xc1,0x04,0x02,0x18]

v_pk_min_i16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x88,0xd3,0xfb,0x04,0x02,0x18]

v_pk_min_i16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x88,0xd3,0xfc,0x04,0x02,0x18]

v_pk_min_i16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x88,0xd3,0xfd,0x04,0x02,0x18]

v_pk_min_i16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x88,0xd3,0xfe,0x04,0x02,0x18]

v_pk_min_i16 v5, v1, v255
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xff,0x03,0x18]

v_pk_min_i16 v5, v1, s2
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x00,0x18]

v_pk_min_i16 v5, v1, s101
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xcb,0x00,0x18]

v_pk_min_i16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xcd,0x00,0x18]

v_pk_min_i16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xcf,0x00,0x18]

v_pk_min_i16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xd5,0x00,0x18]

v_pk_min_i16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xd7,0x00,0x18]

v_pk_min_i16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xf7,0x00,0x18]

v_pk_min_i16 v5, v1, m0
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xf9,0x00,0x18]

v_pk_min_i16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xfd,0x00,0x18]

v_pk_min_i16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xff,0x00,0x18]

v_pk_min_i16 v5, v1, 0
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x01,0x01,0x18]

v_pk_min_i16 v5, v1, -1
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x83,0x01,0x18]

v_pk_min_i16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xf7,0x01,0x18]

v_pk_min_i16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xf9,0x01,0x18]

v_pk_min_i16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0xfb,0x01,0x18]

v_pk_min_i16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x02,0x00]

v_pk_min_i16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x02,0x08]

v_pk_min_i16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x88,0xd3,0x01,0x05,0x02,0x10]

v_pk_mad_u16 v5, v1, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v255, v1, v2, v3
// CHECK: [0xff,0x40,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v255, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0xff,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, s1, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, s101, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x65,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x66,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x67,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x6a,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x6b,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, ttmp15, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x7b,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, m0, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x7c,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x7e,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x7f,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, 0, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x80,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, -1, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0xc1,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0xfb,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, src_execz, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0xfc,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, src_scc, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0xfd,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0xfe,0x04,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v255, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xff,0x0f,0x1c]

v_pk_mad_u16 v5, v1, s2, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x0c,0x1c]

v_pk_mad_u16 v5, v1, s101, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xcb,0x0c,0x1c]

v_pk_mad_u16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xcd,0x0c,0x1c]

v_pk_mad_u16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xcf,0x0c,0x1c]

v_pk_mad_u16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xd5,0x0c,0x1c]

v_pk_mad_u16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xd7,0x0c,0x1c]

v_pk_mad_u16 v5, v1, ttmp15, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xf7,0x0c,0x1c]

v_pk_mad_u16 v5, v1, m0, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xf9,0x0c,0x1c]

v_pk_mad_u16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xfd,0x0c,0x1c]

v_pk_mad_u16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xff,0x0c,0x1c]

v_pk_mad_u16 v5, v1, 0, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x01,0x0d,0x1c]

v_pk_mad_u16 v5, v1, -1, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x83,0x0d,0x1c]

v_pk_mad_u16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xf7,0x0d,0x1c]

v_pk_mad_u16 v5, v1, src_execz, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xf9,0x0d,0x1c]

v_pk_mad_u16 v5, v1, src_scc, v3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0xfb,0x0d,0x1c]

v_pk_mad_u16 v5, v1, v2, v255
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xfe,0x1f]

v_pk_mad_u16 v5, v1, v2, s3
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x0e,0x18]

v_pk_mad_u16 v5, v1, v2, s101
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x96,0x19]

v_pk_mad_u16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x9a,0x19]

v_pk_mad_u16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x9e,0x19]

v_pk_mad_u16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xaa,0x19]

v_pk_mad_u16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xae,0x19]

v_pk_mad_u16 v5, v1, v2, ttmp15
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xee,0x19]

v_pk_mad_u16 v5, v1, v2, m0
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xf2,0x19]

v_pk_mad_u16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xfa,0x19]

v_pk_mad_u16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xfe,0x19]

v_pk_mad_u16 v5, v1, v2, 0
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x02,0x1a]

v_pk_mad_u16 v5, v1, v2, -1
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x06,0x1b]

v_pk_mad_u16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xee,0x1b]

v_pk_mad_u16 v5, v1, v2, src_execz
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xf2,0x1b]

v_pk_mad_u16 v5, v1, v2, src_scc
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0xf6,0x1b]

v_pk_mad_u16 v5, v1, v2, v3 op_sel:[0,0,0]
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel:[1,0,0]
// CHECK: [0x05,0x48,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel:[0,1,0]
// CHECK: [0x05,0x50,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel:[0,0,1]
// CHECK: [0x05,0x60,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel:[1,1,1]
// CHECK: [0x05,0x78,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel_hi:[1,1,1]
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel_hi:[0,0,0]
// CHECK: [0x05,0x00,0x89,0xd3,0x01,0x05,0x0e,0x04]

v_pk_mad_u16 v5, v1, v2, v3 op_sel_hi:[1,0,0]
// CHECK: [0x05,0x00,0x89,0xd3,0x01,0x05,0x0e,0x0c]

v_pk_mad_u16 v5, v1, v2, v3 op_sel_hi:[0,1,0]
// CHECK: [0x05,0x00,0x89,0xd3,0x01,0x05,0x0e,0x14]

v_pk_mad_u16 v5, v1, v2, v3 op_sel_hi:[0,0,1]
// CHECK: [0x05,0x40,0x89,0xd3,0x01,0x05,0x0e,0x04]

v_pk_mad_u16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0xc0,0x89,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_add_u16 v5, v1, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v255, v1, v2
// CHECK: [0xff,0x40,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v255, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0xff,0x05,0x02,0x18]

v_pk_add_u16 v5, s1, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x04,0x02,0x18]

v_pk_add_u16 v5, s101, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x65,0x04,0x02,0x18]

v_pk_add_u16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x66,0x04,0x02,0x18]

v_pk_add_u16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x67,0x04,0x02,0x18]

v_pk_add_u16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x6a,0x04,0x02,0x18]

v_pk_add_u16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x6b,0x04,0x02,0x18]

v_pk_add_u16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x7b,0x04,0x02,0x18]

v_pk_add_u16 v5, m0, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x7c,0x04,0x02,0x18]

v_pk_add_u16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x7e,0x04,0x02,0x18]

v_pk_add_u16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x7f,0x04,0x02,0x18]

v_pk_add_u16 v5, 0, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0x80,0x04,0x02,0x18]

v_pk_add_u16 v5, -1, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0xc1,0x04,0x02,0x18]

v_pk_add_u16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0xfb,0x04,0x02,0x18]

v_pk_add_u16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0xfc,0x04,0x02,0x18]

v_pk_add_u16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0xfd,0x04,0x02,0x18]

v_pk_add_u16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x8a,0xd3,0xfe,0x04,0x02,0x18]

v_pk_add_u16 v5, v1, v255
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xff,0x03,0x18]

v_pk_add_u16 v5, v1, s2
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x00,0x18]

v_pk_add_u16 v5, v1, s101
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xcb,0x00,0x18]

v_pk_add_u16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xcd,0x00,0x18]

v_pk_add_u16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xcf,0x00,0x18]

v_pk_add_u16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xd5,0x00,0x18]

v_pk_add_u16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xd7,0x00,0x18]

v_pk_add_u16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xf7,0x00,0x18]

v_pk_add_u16 v5, v1, m0
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xf9,0x00,0x18]

v_pk_add_u16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xfd,0x00,0x18]

v_pk_add_u16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xff,0x00,0x18]

v_pk_add_u16 v5, v1, 0
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x01,0x01,0x18]

v_pk_add_u16 v5, v1, -1
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x83,0x01,0x18]

v_pk_add_u16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xf7,0x01,0x18]

v_pk_add_u16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xf9,0x01,0x18]

v_pk_add_u16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0xfb,0x01,0x18]

v_pk_add_u16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x02,0x00]

v_pk_add_u16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x02,0x08]

v_pk_add_u16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x8a,0xd3,0x01,0x05,0x02,0x10]

v_pk_add_u16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x8a,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v1, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v255, v1, v2
// CHECK: [0xff,0x40,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v255, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0xff,0x05,0x02,0x18]

v_pk_sub_u16 v5, s1, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x04,0x02,0x18]

v_pk_sub_u16 v5, s101, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x65,0x04,0x02,0x18]

v_pk_sub_u16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x66,0x04,0x02,0x18]

v_pk_sub_u16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x67,0x04,0x02,0x18]

v_pk_sub_u16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x6a,0x04,0x02,0x18]

v_pk_sub_u16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x6b,0x04,0x02,0x18]

v_pk_sub_u16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x7b,0x04,0x02,0x18]

v_pk_sub_u16 v5, m0, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x7c,0x04,0x02,0x18]

v_pk_sub_u16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x7e,0x04,0x02,0x18]

v_pk_sub_u16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x7f,0x04,0x02,0x18]

v_pk_sub_u16 v5, 0, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0x80,0x04,0x02,0x18]

v_pk_sub_u16 v5, -1, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0xc1,0x04,0x02,0x18]

v_pk_sub_u16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0xfb,0x04,0x02,0x18]

v_pk_sub_u16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0xfc,0x04,0x02,0x18]

v_pk_sub_u16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0xfd,0x04,0x02,0x18]

v_pk_sub_u16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x8b,0xd3,0xfe,0x04,0x02,0x18]

v_pk_sub_u16 v5, v1, v255
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xff,0x03,0x18]

v_pk_sub_u16 v5, v1, s2
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x00,0x18]

v_pk_sub_u16 v5, v1, s101
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xcb,0x00,0x18]

v_pk_sub_u16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xcd,0x00,0x18]

v_pk_sub_u16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xcf,0x00,0x18]

v_pk_sub_u16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xd5,0x00,0x18]

v_pk_sub_u16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xd7,0x00,0x18]

v_pk_sub_u16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xf7,0x00,0x18]

v_pk_sub_u16 v5, v1, m0
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xf9,0x00,0x18]

v_pk_sub_u16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xfd,0x00,0x18]

v_pk_sub_u16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xff,0x00,0x18]

v_pk_sub_u16 v5, v1, 0
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x01,0x01,0x18]

v_pk_sub_u16 v5, v1, -1
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x83,0x01,0x18]

v_pk_sub_u16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xf7,0x01,0x18]

v_pk_sub_u16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xf9,0x01,0x18]

v_pk_sub_u16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0xfb,0x01,0x18]

v_pk_sub_u16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x02,0x00]

v_pk_sub_u16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x02,0x08]

v_pk_sub_u16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x8b,0xd3,0x01,0x05,0x02,0x10]

v_pk_sub_u16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x8b,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v1, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v255, v1, v2
// CHECK: [0xff,0x40,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v255, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0xff,0x05,0x02,0x18]

v_pk_max_u16 v5, s1, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x04,0x02,0x18]

v_pk_max_u16 v5, s101, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x65,0x04,0x02,0x18]

v_pk_max_u16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x66,0x04,0x02,0x18]

v_pk_max_u16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x67,0x04,0x02,0x18]

v_pk_max_u16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x6a,0x04,0x02,0x18]

v_pk_max_u16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x6b,0x04,0x02,0x18]

v_pk_max_u16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x7b,0x04,0x02,0x18]

v_pk_max_u16 v5, m0, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x7c,0x04,0x02,0x18]

v_pk_max_u16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x7e,0x04,0x02,0x18]

v_pk_max_u16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x7f,0x04,0x02,0x18]

v_pk_max_u16 v5, 0, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0x80,0x04,0x02,0x18]

v_pk_max_u16 v5, -1, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0xc1,0x04,0x02,0x18]

v_pk_max_u16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0xfb,0x04,0x02,0x18]

v_pk_max_u16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0xfc,0x04,0x02,0x18]

v_pk_max_u16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0xfd,0x04,0x02,0x18]

v_pk_max_u16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x8c,0xd3,0xfe,0x04,0x02,0x18]

v_pk_max_u16 v5, v1, v255
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xff,0x03,0x18]

v_pk_max_u16 v5, v1, s2
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x00,0x18]

v_pk_max_u16 v5, v1, s101
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xcb,0x00,0x18]

v_pk_max_u16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xcd,0x00,0x18]

v_pk_max_u16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xcf,0x00,0x18]

v_pk_max_u16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xd5,0x00,0x18]

v_pk_max_u16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xd7,0x00,0x18]

v_pk_max_u16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xf7,0x00,0x18]

v_pk_max_u16 v5, v1, m0
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xf9,0x00,0x18]

v_pk_max_u16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xfd,0x00,0x18]

v_pk_max_u16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xff,0x00,0x18]

v_pk_max_u16 v5, v1, 0
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x01,0x01,0x18]

v_pk_max_u16 v5, v1, -1
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x83,0x01,0x18]

v_pk_max_u16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xf7,0x01,0x18]

v_pk_max_u16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xf9,0x01,0x18]

v_pk_max_u16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0xfb,0x01,0x18]

v_pk_max_u16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x02,0x00]

v_pk_max_u16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x02,0x08]

v_pk_max_u16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x8c,0xd3,0x01,0x05,0x02,0x10]

v_pk_min_u16 v5, v1, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v255, v1, v2
// CHECK: [0xff,0x40,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v255, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0xff,0x05,0x02,0x18]

v_pk_min_u16 v5, s1, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x04,0x02,0x18]

v_pk_min_u16 v5, s101, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x65,0x04,0x02,0x18]

v_pk_min_u16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x66,0x04,0x02,0x18]

v_pk_min_u16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x67,0x04,0x02,0x18]

v_pk_min_u16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x6a,0x04,0x02,0x18]

v_pk_min_u16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x6b,0x04,0x02,0x18]

v_pk_min_u16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x7b,0x04,0x02,0x18]

v_pk_min_u16 v5, m0, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x7c,0x04,0x02,0x18]

v_pk_min_u16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x7e,0x04,0x02,0x18]

v_pk_min_u16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x7f,0x04,0x02,0x18]

v_pk_min_u16 v5, 0, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0x80,0x04,0x02,0x18]

v_pk_min_u16 v5, -1, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0xc1,0x04,0x02,0x18]

v_pk_min_u16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0xfb,0x04,0x02,0x18]

v_pk_min_u16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0xfc,0x04,0x02,0x18]

v_pk_min_u16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0xfd,0x04,0x02,0x18]

v_pk_min_u16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x8d,0xd3,0xfe,0x04,0x02,0x18]

v_pk_min_u16 v5, v1, v255
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xff,0x03,0x18]

v_pk_min_u16 v5, v1, s2
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x00,0x18]

v_pk_min_u16 v5, v1, s101
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xcb,0x00,0x18]

v_pk_min_u16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xcd,0x00,0x18]

v_pk_min_u16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xcf,0x00,0x18]

v_pk_min_u16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xd5,0x00,0x18]

v_pk_min_u16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xd7,0x00,0x18]

v_pk_min_u16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xf7,0x00,0x18]

v_pk_min_u16 v5, v1, m0
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xf9,0x00,0x18]

v_pk_min_u16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xfd,0x00,0x18]

v_pk_min_u16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xff,0x00,0x18]

v_pk_min_u16 v5, v1, 0
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x01,0x01,0x18]

v_pk_min_u16 v5, v1, -1
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x83,0x01,0x18]

v_pk_min_u16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xf7,0x01,0x18]

v_pk_min_u16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xf9,0x01,0x18]

v_pk_min_u16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0xfb,0x01,0x18]

v_pk_min_u16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x02,0x00]

v_pk_min_u16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x02,0x08]

v_pk_min_u16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x8d,0xd3,0x01,0x05,0x02,0x10]

v_pk_fma_f16 v5, v1, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v255, v1, v2, v3
// CHECK: [0xff,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v255, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xff,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, s1, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, s101, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x65,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x66,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x67,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x6a,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x6b,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, ttmp15, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x7b,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, m0, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x7c,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x7e,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x7f,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, 0, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x80,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, -1, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xc1,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, 0.5, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xf0,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, -4.0, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xf7,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xfb,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, src_execz, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xfc,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, src_scc, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xfd,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0xfe,0x04,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v255, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xff,0x0f,0x1c]

v_pk_fma_f16 v5, v1, s2, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0c,0x1c]

v_pk_fma_f16 v5, v1, s101, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xcb,0x0c,0x1c]

v_pk_fma_f16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xcd,0x0c,0x1c]

v_pk_fma_f16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xcf,0x0c,0x1c]

v_pk_fma_f16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xd5,0x0c,0x1c]

v_pk_fma_f16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xd7,0x0c,0x1c]

v_pk_fma_f16 v5, v1, ttmp15, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xf7,0x0c,0x1c]

v_pk_fma_f16 v5, v1, m0, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xf9,0x0c,0x1c]

v_pk_fma_f16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xfd,0x0c,0x1c]

v_pk_fma_f16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xff,0x0c,0x1c]

v_pk_fma_f16 v5, v1, 0, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x01,0x0d,0x1c]

v_pk_fma_f16 v5, v1, -1, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x83,0x0d,0x1c]

v_pk_fma_f16 v5, v1, 0.5, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xe1,0x0d,0x1c]

v_pk_fma_f16 v5, v1, -4.0, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xef,0x0d,0x1c]

v_pk_fma_f16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xf7,0x0d,0x1c]

v_pk_fma_f16 v5, v1, src_execz, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xf9,0x0d,0x1c]

v_pk_fma_f16 v5, v1, src_scc, v3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0xfb,0x0d,0x1c]

v_pk_fma_f16 v5, v1, v2, v255
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xfe,0x1f]

v_pk_fma_f16 v5, v1, v2, s3
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x18]

v_pk_fma_f16 v5, v1, v2, s101
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x96,0x19]

v_pk_fma_f16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x9a,0x19]

v_pk_fma_f16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x9e,0x19]

v_pk_fma_f16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xaa,0x19]

v_pk_fma_f16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xae,0x19]

v_pk_fma_f16 v5, v1, v2, ttmp15
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xee,0x19]

v_pk_fma_f16 v5, v1, v2, m0
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xf2,0x19]

v_pk_fma_f16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xfa,0x19]

v_pk_fma_f16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xfe,0x19]

v_pk_fma_f16 v5, v1, v2, 0
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x02,0x1a]

v_pk_fma_f16 v5, v1, v2, -1
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x06,0x1b]

v_pk_fma_f16 v5, v1, v2, 0.5
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xc2,0x1b]

v_pk_fma_f16 v5, v1, v2, -4.0
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xde,0x1b]

v_pk_fma_f16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xee,0x1b]

v_pk_fma_f16 v5, v1, v2, src_execz
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xf2,0x1b]

v_pk_fma_f16 v5, v1, v2, src_scc
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0xf6,0x1b]

v_pk_fma_f16 v5, v1, v2, v3 op_sel:[0,0,0]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel:[1,0,0]
// CHECK: [0x05,0x48,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel:[0,1,0]
// CHECK: [0x05,0x50,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel:[0,0,1]
// CHECK: [0x05,0x60,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel:[1,1,1]
// CHECK: [0x05,0x78,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel_hi:[1,1,1]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel_hi:[0,0,0]
// CHECK: [0x05,0x00,0x8e,0xd3,0x01,0x05,0x0e,0x04]

v_pk_fma_f16 v5, v1, v2, v3 op_sel_hi:[1,0,0]
// CHECK: [0x05,0x00,0x8e,0xd3,0x01,0x05,0x0e,0x0c]

v_pk_fma_f16 v5, v1, v2, v3 op_sel_hi:[0,1,0]
// CHECK: [0x05,0x00,0x8e,0xd3,0x01,0x05,0x0e,0x14]

v_pk_fma_f16 v5, v1, v2, v3 op_sel_hi:[0,0,1]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x04]

v_pk_fma_f16 v5, v1, v2, v3 neg_lo:[1,0,0]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x3c]

v_pk_fma_f16 v5, v1, v2, v3 neg_lo:[0,1,0]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x5c]

v_pk_fma_f16 v5, v1, v2, v3 neg_lo:[0,0,1]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0x9c]

v_pk_fma_f16 v5, v1, v2, v3 neg_lo:[1,1,1]
// CHECK: [0x05,0x40,0x8e,0xd3,0x01,0x05,0x0e,0xfc]

v_pk_fma_f16 v5, v1, v2, v3 neg_hi:[1,0,0]
// CHECK: [0x05,0x41,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 neg_hi:[0,1,0]
// CHECK: [0x05,0x42,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 neg_hi:[0,0,1]
// CHECK: [0x05,0x44,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 neg_hi:[1,1,1]
// CHECK: [0x05,0x47,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_fma_f16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0xc0,0x8e,0xd3,0x01,0x05,0x0e,0x1c]

v_pk_add_f16 v5, v1, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v255, v1, v2
// CHECK: [0xff,0x40,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v255, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xff,0x05,0x02,0x18]

v_pk_add_f16 v5, s1, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x04,0x02,0x18]

v_pk_add_f16 v5, s101, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x65,0x04,0x02,0x18]

v_pk_add_f16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x66,0x04,0x02,0x18]

v_pk_add_f16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x67,0x04,0x02,0x18]

v_pk_add_f16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x6a,0x04,0x02,0x18]

v_pk_add_f16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x6b,0x04,0x02,0x18]

v_pk_add_f16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x7b,0x04,0x02,0x18]

v_pk_add_f16 v5, m0, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x7c,0x04,0x02,0x18]

v_pk_add_f16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x7e,0x04,0x02,0x18]

v_pk_add_f16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x7f,0x04,0x02,0x18]

v_pk_add_f16 v5, 0, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0x80,0x04,0x02,0x18]

v_pk_add_f16 v5, -1, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xc1,0x04,0x02,0x18]

v_pk_add_f16 v5, 0.5, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xf0,0x04,0x02,0x18]

v_pk_add_f16 v5, -4.0, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xf7,0x04,0x02,0x18]

v_pk_add_f16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xfb,0x04,0x02,0x18]

v_pk_add_f16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xfc,0x04,0x02,0x18]

v_pk_add_f16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xfd,0x04,0x02,0x18]

v_pk_add_f16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x8f,0xd3,0xfe,0x04,0x02,0x18]

v_pk_add_f16 v5, v1, v255
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xff,0x03,0x18]

v_pk_add_f16 v5, v1, s2
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x00,0x18]

v_pk_add_f16 v5, v1, s101
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xcb,0x00,0x18]

v_pk_add_f16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xcd,0x00,0x18]

v_pk_add_f16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xcf,0x00,0x18]

v_pk_add_f16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xd5,0x00,0x18]

v_pk_add_f16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xd7,0x00,0x18]

v_pk_add_f16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xf7,0x00,0x18]

v_pk_add_f16 v5, v1, m0
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xf9,0x00,0x18]

v_pk_add_f16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xfd,0x00,0x18]

v_pk_add_f16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xff,0x00,0x18]

v_pk_add_f16 v5, v1, 0
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x01,0x01,0x18]

v_pk_add_f16 v5, v1, -1
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x83,0x01,0x18]

v_pk_add_f16 v5, v1, 0.5
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xe1,0x01,0x18]

v_pk_add_f16 v5, v1, -4.0
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xef,0x01,0x18]

v_pk_add_f16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xf7,0x01,0x18]

v_pk_add_f16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xf9,0x01,0x18]

v_pk_add_f16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0xfb,0x01,0x18]

v_pk_add_f16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x00]

v_pk_add_f16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x08]

v_pk_add_f16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x10]

v_pk_add_f16 v5, v1, v2 neg_lo:[1,0]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x38]

v_pk_add_f16 v5, v1, v2 neg_lo:[0,1]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x58]

v_pk_add_f16 v5, v1, v2 neg_lo:[1,1]
// CHECK: [0x05,0x40,0x8f,0xd3,0x01,0x05,0x02,0x78]

v_pk_add_f16 v5, v1, v2 neg_hi:[1,0]
// CHECK: [0x05,0x41,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 neg_hi:[0,1]
// CHECK: [0x05,0x42,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 neg_hi:[1,1]
// CHECK: [0x05,0x43,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x8f,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v255, v1, v2
// CHECK: [0xff,0x40,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v255, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xff,0x05,0x02,0x18]

v_pk_mul_f16 v5, s1, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x04,0x02,0x18]

v_pk_mul_f16 v5, s101, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x65,0x04,0x02,0x18]

v_pk_mul_f16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x66,0x04,0x02,0x18]

v_pk_mul_f16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x67,0x04,0x02,0x18]

v_pk_mul_f16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x6a,0x04,0x02,0x18]

v_pk_mul_f16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x6b,0x04,0x02,0x18]

v_pk_mul_f16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x7b,0x04,0x02,0x18]

v_pk_mul_f16 v5, m0, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x7c,0x04,0x02,0x18]

v_pk_mul_f16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x7e,0x04,0x02,0x18]

v_pk_mul_f16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x7f,0x04,0x02,0x18]

v_pk_mul_f16 v5, 0, v2
// CHECK: [0x05,0x40,0x90,0xd3,0x80,0x04,0x02,0x18]

v_pk_mul_f16 v5, -1, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xc1,0x04,0x02,0x18]

v_pk_mul_f16 v5, 0.5, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xf0,0x04,0x02,0x18]

v_pk_mul_f16 v5, -4.0, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xf7,0x04,0x02,0x18]

v_pk_mul_f16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xfb,0x04,0x02,0x18]

v_pk_mul_f16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xfc,0x04,0x02,0x18]

v_pk_mul_f16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xfd,0x04,0x02,0x18]

v_pk_mul_f16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x90,0xd3,0xfe,0x04,0x02,0x18]

v_pk_mul_f16 v5, v1, v255
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xff,0x03,0x18]

v_pk_mul_f16 v5, v1, s2
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x00,0x18]

v_pk_mul_f16 v5, v1, s101
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xcb,0x00,0x18]

v_pk_mul_f16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xcd,0x00,0x18]

v_pk_mul_f16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xcf,0x00,0x18]

v_pk_mul_f16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xd5,0x00,0x18]

v_pk_mul_f16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xd7,0x00,0x18]

v_pk_mul_f16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xf7,0x00,0x18]

v_pk_mul_f16 v5, v1, m0
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xf9,0x00,0x18]

v_pk_mul_f16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xfd,0x00,0x18]

v_pk_mul_f16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xff,0x00,0x18]

v_pk_mul_f16 v5, v1, 0
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x01,0x01,0x18]

v_pk_mul_f16 v5, v1, -1
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x83,0x01,0x18]

v_pk_mul_f16 v5, v1, 0.5
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xe1,0x01,0x18]

v_pk_mul_f16 v5, v1, -4.0
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xef,0x01,0x18]

v_pk_mul_f16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xf7,0x01,0x18]

v_pk_mul_f16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xf9,0x01,0x18]

v_pk_mul_f16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0xfb,0x01,0x18]

v_pk_mul_f16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x00]

v_pk_mul_f16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x08]

v_pk_mul_f16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x10]

v_pk_mul_f16 v5, v1, v2 neg_lo:[1,0]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x38]

v_pk_mul_f16 v5, v1, v2 neg_lo:[0,1]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x58]

v_pk_mul_f16 v5, v1, v2 neg_lo:[1,1]
// CHECK: [0x05,0x40,0x90,0xd3,0x01,0x05,0x02,0x78]

v_pk_mul_f16 v5, v1, v2 neg_hi:[1,0]
// CHECK: [0x05,0x41,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 neg_hi:[0,1]
// CHECK: [0x05,0x42,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 neg_hi:[1,1]
// CHECK: [0x05,0x43,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x90,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v255, v1, v2
// CHECK: [0xff,0x40,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v255, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xff,0x05,0x02,0x18]

v_pk_min_f16 v5, s1, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x04,0x02,0x18]

v_pk_min_f16 v5, s101, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x65,0x04,0x02,0x18]

v_pk_min_f16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x66,0x04,0x02,0x18]

v_pk_min_f16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x67,0x04,0x02,0x18]

v_pk_min_f16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x6a,0x04,0x02,0x18]

v_pk_min_f16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x6b,0x04,0x02,0x18]

v_pk_min_f16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x7b,0x04,0x02,0x18]

v_pk_min_f16 v5, m0, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x7c,0x04,0x02,0x18]

v_pk_min_f16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x7e,0x04,0x02,0x18]

v_pk_min_f16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x7f,0x04,0x02,0x18]

v_pk_min_f16 v5, 0, v2
// CHECK: [0x05,0x40,0x91,0xd3,0x80,0x04,0x02,0x18]

v_pk_min_f16 v5, -1, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xc1,0x04,0x02,0x18]

v_pk_min_f16 v5, 0.5, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xf0,0x04,0x02,0x18]

v_pk_min_f16 v5, -4.0, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xf7,0x04,0x02,0x18]

v_pk_min_f16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xfb,0x04,0x02,0x18]

v_pk_min_f16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xfc,0x04,0x02,0x18]

v_pk_min_f16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xfd,0x04,0x02,0x18]

v_pk_min_f16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x91,0xd3,0xfe,0x04,0x02,0x18]

v_pk_min_f16 v5, v1, v255
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xff,0x03,0x18]

v_pk_min_f16 v5, v1, s2
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x00,0x18]

v_pk_min_f16 v5, v1, s101
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xcb,0x00,0x18]

v_pk_min_f16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xcd,0x00,0x18]

v_pk_min_f16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xcf,0x00,0x18]

v_pk_min_f16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xd5,0x00,0x18]

v_pk_min_f16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xd7,0x00,0x18]

v_pk_min_f16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xf7,0x00,0x18]

v_pk_min_f16 v5, v1, m0
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xf9,0x00,0x18]

v_pk_min_f16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xfd,0x00,0x18]

v_pk_min_f16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xff,0x00,0x18]

v_pk_min_f16 v5, v1, 0
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x01,0x01,0x18]

v_pk_min_f16 v5, v1, -1
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x83,0x01,0x18]

v_pk_min_f16 v5, v1, 0.5
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xe1,0x01,0x18]

v_pk_min_f16 v5, v1, -4.0
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xef,0x01,0x18]

v_pk_min_f16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xf7,0x01,0x18]

v_pk_min_f16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xf9,0x01,0x18]

v_pk_min_f16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0xfb,0x01,0x18]

v_pk_min_f16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x00]

v_pk_min_f16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x08]

v_pk_min_f16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x10]

v_pk_min_f16 v5, v1, v2 neg_lo:[1,0]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x38]

v_pk_min_f16 v5, v1, v2 neg_lo:[0,1]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x58]

v_pk_min_f16 v5, v1, v2 neg_lo:[1,1]
// CHECK: [0x05,0x40,0x91,0xd3,0x01,0x05,0x02,0x78]

v_pk_min_f16 v5, v1, v2 neg_hi:[1,0]
// CHECK: [0x05,0x41,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 neg_hi:[0,1]
// CHECK: [0x05,0x42,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 neg_hi:[1,1]
// CHECK: [0x05,0x43,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x91,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v255, v1, v2
// CHECK: [0xff,0x40,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v255, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xff,0x05,0x02,0x18]

v_pk_max_f16 v5, s1, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x04,0x02,0x18]

v_pk_max_f16 v5, s101, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x65,0x04,0x02,0x18]

v_pk_max_f16 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x66,0x04,0x02,0x18]

v_pk_max_f16 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x67,0x04,0x02,0x18]

v_pk_max_f16 v5, vcc_lo, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x6a,0x04,0x02,0x18]

v_pk_max_f16 v5, vcc_hi, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x6b,0x04,0x02,0x18]

v_pk_max_f16 v5, ttmp15, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x7b,0x04,0x02,0x18]

v_pk_max_f16 v5, m0, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x7c,0x04,0x02,0x18]

v_pk_max_f16 v5, exec_lo, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x7e,0x04,0x02,0x18]

v_pk_max_f16 v5, exec_hi, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x7f,0x04,0x02,0x18]

v_pk_max_f16 v5, 0, v2
// CHECK: [0x05,0x40,0x92,0xd3,0x80,0x04,0x02,0x18]

v_pk_max_f16 v5, -1, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xc1,0x04,0x02,0x18]

v_pk_max_f16 v5, 0.5, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xf0,0x04,0x02,0x18]

v_pk_max_f16 v5, -4.0, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xf7,0x04,0x02,0x18]

v_pk_max_f16 v5, src_vccz, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xfb,0x04,0x02,0x18]

v_pk_max_f16 v5, src_execz, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xfc,0x04,0x02,0x18]

v_pk_max_f16 v5, src_scc, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xfd,0x04,0x02,0x18]

v_pk_max_f16 v5, src_lds_direct, v2
// CHECK: [0x05,0x40,0x92,0xd3,0xfe,0x04,0x02,0x18]

v_pk_max_f16 v5, v1, v255
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xff,0x03,0x18]

v_pk_max_f16 v5, v1, s2
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x00,0x18]

v_pk_max_f16 v5, v1, s101
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xcb,0x00,0x18]

v_pk_max_f16 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xcd,0x00,0x18]

v_pk_max_f16 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xcf,0x00,0x18]

v_pk_max_f16 v5, v1, vcc_lo
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xd5,0x00,0x18]

v_pk_max_f16 v5, v1, vcc_hi
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xd7,0x00,0x18]

v_pk_max_f16 v5, v1, ttmp15
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xf7,0x00,0x18]

v_pk_max_f16 v5, v1, m0
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xf9,0x00,0x18]

v_pk_max_f16 v5, v1, exec_lo
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xfd,0x00,0x18]

v_pk_max_f16 v5, v1, exec_hi
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xff,0x00,0x18]

v_pk_max_f16 v5, v1, 0
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x01,0x01,0x18]

v_pk_max_f16 v5, v1, -1
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x83,0x01,0x18]

v_pk_max_f16 v5, v1, 0.5
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xe1,0x01,0x18]

v_pk_max_f16 v5, v1, -4.0
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xef,0x01,0x18]

v_pk_max_f16 v5, v1, src_vccz
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xf7,0x01,0x18]

v_pk_max_f16 v5, v1, src_execz
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xf9,0x01,0x18]

v_pk_max_f16 v5, v1, src_scc
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0xfb,0x01,0x18]

v_pk_max_f16 v5, v1, v2 op_sel:[0,0]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 op_sel:[1,0]
// CHECK: [0x05,0x48,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 op_sel:[0,1]
// CHECK: [0x05,0x50,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 op_sel:[1,1]
// CHECK: [0x05,0x58,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 op_sel_hi:[1,1]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 op_sel_hi:[0,0]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x00]

v_pk_max_f16 v5, v1, v2 op_sel_hi:[1,0]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x08]

v_pk_max_f16 v5, v1, v2 op_sel_hi:[0,1]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x10]

v_pk_max_f16 v5, v1, v2 neg_lo:[1,0]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x38]

v_pk_max_f16 v5, v1, v2 neg_lo:[0,1]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x58]

v_pk_max_f16 v5, v1, v2 neg_lo:[1,1]
// CHECK: [0x05,0x40,0x92,0xd3,0x01,0x05,0x02,0x78]

v_pk_max_f16 v5, v1, v2 neg_hi:[1,0]
// CHECK: [0x05,0x41,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 neg_hi:[0,1]
// CHECK: [0x05,0x42,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 neg_hi:[1,1]
// CHECK: [0x05,0x43,0x92,0xd3,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v1, v2 clamp
// CHECK: [0x05,0xc0,0x92,0xd3,0x01,0x05,0x02,0x18]

v_mad_mix_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xff,0x05,0x0e,0x04]

v_mad_mix_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x04,0x0e,0x04]

v_mad_mix_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x65,0x04,0x0e,0x04]

v_mad_mix_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x66,0x04,0x0e,0x04]

v_mad_mix_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x67,0x04,0x0e,0x04]

v_mad_mix_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x6a,0x04,0x0e,0x04]

v_mad_mix_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x6b,0x04,0x0e,0x04]

v_mad_mix_f32 v5, ttmp15, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x7b,0x04,0x0e,0x04]

v_mad_mix_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x7c,0x04,0x0e,0x04]

v_mad_mix_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x7e,0x04,0x0e,0x04]

v_mad_mix_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x7f,0x04,0x0e,0x04]

v_mad_mix_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x80,0x04,0x0e,0x04]

v_mad_mix_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xc1,0x04,0x0e,0x04]

v_mad_mix_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xf0,0x04,0x0e,0x04]

v_mad_mix_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xf7,0x04,0x0e,0x04]

v_mad_mix_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xfb,0x04,0x0e,0x04]

v_mad_mix_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xfc,0x04,0x0e,0x04]

v_mad_mix_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xfd,0x04,0x0e,0x04]

v_mad_mix_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0xfe,0x04,0x0e,0x04]

v_mad_mix_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xff,0x0f,0x04]

v_mad_mix_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0c,0x04]

v_mad_mix_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xcb,0x0c,0x04]

v_mad_mix_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xcd,0x0c,0x04]

v_mad_mix_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xcf,0x0c,0x04]

v_mad_mix_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xd5,0x0c,0x04]

v_mad_mix_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xd7,0x0c,0x04]

v_mad_mix_f32 v5, v1, ttmp15, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xf7,0x0c,0x04]

v_mad_mix_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xf9,0x0c,0x04]

v_mad_mix_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xfd,0x0c,0x04]

v_mad_mix_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xff,0x0c,0x04]

v_mad_mix_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x01,0x0d,0x04]

v_mad_mix_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x83,0x0d,0x04]

v_mad_mix_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xe1,0x0d,0x04]

v_mad_mix_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xef,0x0d,0x04]

v_mad_mix_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xf7,0x0d,0x04]

v_mad_mix_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xf9,0x0d,0x04]

v_mad_mix_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0xfb,0x0d,0x04]

v_mad_mix_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xfe,0x07]

v_mad_mix_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x00]

v_mad_mix_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x96,0x01]

v_mad_mix_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x9a,0x01]

v_mad_mix_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x9e,0x01]

v_mad_mix_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xaa,0x01]

v_mad_mix_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xae,0x01]

v_mad_mix_f32 v5, v1, v2, ttmp15
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xee,0x01]

v_mad_mix_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xf2,0x01]

v_mad_mix_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xfa,0x01]

v_mad_mix_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xfe,0x01]

v_mad_mix_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x02,0x02]

v_mad_mix_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x06,0x03]

v_mad_mix_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xc2,0x03]

v_mad_mix_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xde,0x03]

v_mad_mix_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xee,0x03]

v_mad_mix_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xf2,0x03]

v_mad_mix_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0xf6,0x03]

v_mad_mix_f32 v5, v1, v2, v3 op_sel:[0,0,0]
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel:[1,0,0]
// CHECK: [0x05,0x08,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel:[0,1,0]
// CHECK: [0x05,0x10,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel:[0,0,1]
// CHECK: [0x05,0x20,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel:[1,1,1]
// CHECK: [0x05,0x38,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel_hi:[0,0,0]
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel_hi:[1,0,0]
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x0c]

v_mad_mix_f32 v5, v1, v2, v3 op_sel_hi:[0,1,0]
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x14]

v_mad_mix_f32 v5, v1, v2, v3 op_sel_hi:[0,0,1]
// CHECK: [0x05,0x40,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 op_sel_hi:[1,1,1]
// CHECK: [0x05,0x40,0xa0,0xd3,0x01,0x05,0x0e,0x1c]

v_mad_mix_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x24]

v_mad_mix_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x44]

v_mad_mix_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0x84]

v_mad_mix_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xa0,0xd3,0x01,0x05,0x0e,0xe4]

v_mad_mix_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mix_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xa0,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xff,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x65,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x66,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x67,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x6a,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x6b,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, ttmp15, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x7b,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x7c,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x7e,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x7f,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x80,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xc1,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xf0,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xf7,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xfb,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xfc,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xfd,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0xfe,0x04,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xff,0x0f,0x04]

v_mad_mixlo_f16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xcb,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xcd,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xcf,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xd5,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xd7,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, ttmp15, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xf7,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xf9,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xfd,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xff,0x0c,0x04]

v_mad_mixlo_f16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x01,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x83,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xe1,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xef,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xf7,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xf9,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0xfb,0x0d,0x04]

v_mad_mixlo_f16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xfe,0x07]

v_mad_mixlo_f16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x00]

v_mad_mixlo_f16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x96,0x01]

v_mad_mixlo_f16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x9a,0x01]

v_mad_mixlo_f16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x9e,0x01]

v_mad_mixlo_f16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xaa,0x01]

v_mad_mixlo_f16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xae,0x01]

v_mad_mixlo_f16 v5, v1, v2, ttmp15
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xee,0x01]

v_mad_mixlo_f16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xf2,0x01]

v_mad_mixlo_f16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xfa,0x01]

v_mad_mixlo_f16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xfe,0x01]

v_mad_mixlo_f16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x02,0x02]

v_mad_mixlo_f16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x06,0x03]

v_mad_mixlo_f16 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xc2,0x03]

v_mad_mixlo_f16 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xde,0x03]

v_mad_mixlo_f16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xee,0x03]

v_mad_mixlo_f16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xf2,0x03]

v_mad_mixlo_f16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0xf6,0x03]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel:[0,0,0]
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel:[1,0,0]
// CHECK: [0x05,0x08,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel:[0,1,0]
// CHECK: [0x05,0x10,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel:[0,0,1]
// CHECK: [0x05,0x20,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel:[1,1,1]
// CHECK: [0x05,0x38,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel_hi:[0,0,0]
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel_hi:[1,0,0]
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x0c]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel_hi:[0,1,0]
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x14]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel_hi:[0,0,1]
// CHECK: [0x05,0x40,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 op_sel_hi:[1,1,1]
// CHECK: [0x05,0x40,0xa1,0xd3,0x01,0x05,0x0e,0x1c]

v_mad_mixlo_f16 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x24]

v_mad_mixlo_f16 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x44]

v_mad_mixlo_f16 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0x84]

v_mad_mixlo_f16 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xa1,0xd3,0x01,0x05,0x0e,0xe4]

v_mad_mixlo_f16 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixlo_f16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xa1,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xff,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x65,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x66,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x67,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x6a,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x6b,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, ttmp15, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x7b,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x7c,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x7e,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x7f,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x80,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xc1,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xf0,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xf7,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xfb,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xfc,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xfd,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0xfe,0x04,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xff,0x0f,0x04]

v_mad_mixhi_f16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xcb,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xcd,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xcf,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xd5,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xd7,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, ttmp15, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xf7,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xf9,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xfd,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xff,0x0c,0x04]

v_mad_mixhi_f16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x01,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x83,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xe1,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xef,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xf7,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xf9,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0xfb,0x0d,0x04]

v_mad_mixhi_f16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xfe,0x07]

v_mad_mixhi_f16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x00]

v_mad_mixhi_f16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x96,0x01]

v_mad_mixhi_f16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x9a,0x01]

v_mad_mixhi_f16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x9e,0x01]

v_mad_mixhi_f16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xaa,0x01]

v_mad_mixhi_f16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xae,0x01]

v_mad_mixhi_f16 v5, v1, v2, ttmp15
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xee,0x01]

v_mad_mixhi_f16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xf2,0x01]

v_mad_mixhi_f16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xfa,0x01]

v_mad_mixhi_f16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xfe,0x01]

v_mad_mixhi_f16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x02,0x02]

v_mad_mixhi_f16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x06,0x03]

v_mad_mixhi_f16 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xc2,0x03]

v_mad_mixhi_f16 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xde,0x03]

v_mad_mixhi_f16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xee,0x03]

v_mad_mixhi_f16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xf2,0x03]

v_mad_mixhi_f16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0xf6,0x03]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel:[0,0,0]
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel:[1,0,0]
// CHECK: [0x05,0x08,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel:[0,1,0]
// CHECK: [0x05,0x10,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel:[0,0,1]
// CHECK: [0x05,0x20,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel:[1,1,1]
// CHECK: [0x05,0x38,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel_hi:[0,0,0]
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel_hi:[1,0,0]
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x0c]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel_hi:[0,1,0]
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x14]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel_hi:[0,0,1]
// CHECK: [0x05,0x40,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 op_sel_hi:[1,1,1]
// CHECK: [0x05,0x40,0xa2,0xd3,0x01,0x05,0x0e,0x1c]

v_mad_mixhi_f16 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x24]

v_mad_mixhi_f16 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x44]

v_mad_mixhi_f16 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0x84]

v_mad_mixhi_f16 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xa2,0xd3,0x01,0x05,0x0e,0xe4]

v_mad_mixhi_f16 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xa2,0xd3,0x01,0x05,0x0e,0x04]

v_mad_mixhi_f16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xa2,0xd3,0x01,0x05,0x0e,0x04]
