; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=sparc < %s | FileCheck %s --check-prefixes=CHECK32
; RUN: llc -mtriple=sparcv9 < %s | FileCheck %s --check-prefixes=CHECK64

define void @variable_alloca_with_overalignment(i32 %num) nounwind {
; CHECK32-LABEL: variable_alloca_with_overalignment:
; CHECK32:       ! %bb.0:
; CHECK32-NEXT:    save %sp, -96, %sp
; CHECK32-NEXT:    add %sp, 80, %i1
; CHECK32-NEXT:    and %i1, -64, %o0
; CHECK32-NEXT:    add %o0, -96, %sp
; CHECK32-NEXT:    add %i0, 7, %i0
; CHECK32-NEXT:    and %i0, -8, %i0
; CHECK32-NEXT:    sub %sp, %i0, %i0
; CHECK32-NEXT:    add %i0, -8, %sp
; CHECK32-NEXT:    call foo
; CHECK32-NEXT:    add %i0, 88, %o1
; CHECK32-NEXT:    ret
; CHECK32-NEXT:    restore
;
; CHECK64-LABEL: variable_alloca_with_overalignment:
; CHECK64:       ! %bb.0:
; CHECK64-NEXT:    save %sp, -128, %sp
; CHECK64-NEXT:    add %sp, 2159, %i1
; CHECK64-NEXT:    and %i1, -64, %o0
; CHECK64-NEXT:    add %o0, -2175, %sp
; CHECK64-NEXT:    srl %i0, 0, %i0
; CHECK64-NEXT:    add %i0, 15, %i0
; CHECK64-NEXT:    sethi 4194303, %i1
; CHECK64-NEXT:    or %i1, 1008, %i1
; CHECK64-NEXT:    sethi 0, %i2
; CHECK64-NEXT:    or %i2, 1, %i2
; CHECK64-NEXT:    sllx %i2, 32, %i2
; CHECK64-NEXT:    or %i2, %i1, %i1
; CHECK64-NEXT:    and %i0, %i1, %i0
; CHECK64-NEXT:    sub %sp, %i0, %i0
; CHECK64-NEXT:    add %i0, 2175, %o1
; CHECK64-NEXT:    mov %i0, %sp
; CHECK64-NEXT:    call foo
; CHECK64-NEXT:    add %sp, -48, %sp
; CHECK64-NEXT:    add %sp, 48, %sp
; CHECK64-NEXT:    ret
; CHECK64-NEXT:    restore
  %aligned = alloca i32, align 64
  %var_size = alloca i8, i32 %num, align 4
  call void @foo(ptr %aligned, ptr %var_size)
  ret void
}

;; Same but with the alloca itself overaligned
define void @variable_alloca_with_overalignment_2(i32 %num) nounwind {
; CHECK32-LABEL: variable_alloca_with_overalignment_2:
; CHECK32:       ! %bb.0:
; CHECK32-NEXT:    save %sp, -96, %sp
; CHECK32-NEXT:    add %i0, 7, %i0
; CHECK32-NEXT:    and %i0, -8, %i0
; CHECK32-NEXT:    sub %sp, %i0, %i0
; CHECK32-NEXT:    add %i0, 88, %i0
; CHECK32-NEXT:    and %i0, -64, %o1
; CHECK32-NEXT:    add %o1, -96, %sp
; CHECK32-NEXT:    call foo
; CHECK32-NEXT:    mov %g0, %o0
; CHECK32-NEXT:    ret
; CHECK32-NEXT:    restore
;
; CHECK64-LABEL: variable_alloca_with_overalignment_2:
; CHECK64:       ! %bb.0:
; CHECK64-NEXT:    save %sp, -128, %sp
; CHECK64-NEXT:    srl %i0, 0, %i0
; CHECK64-NEXT:    add %i0, 15, %i0
; CHECK64-NEXT:    sethi 4194303, %i1
; CHECK64-NEXT:    or %i1, 1008, %i1
; CHECK64-NEXT:    sethi 0, %i2
; CHECK64-NEXT:    or %i2, 1, %i2
; CHECK64-NEXT:    sllx %i2, 32, %i2
; CHECK64-NEXT:    or %i2, %i1, %i1
; CHECK64-NEXT:    and %i0, %i1, %i0
; CHECK64-NEXT:    sub %sp, %i0, %i0
; CHECK64-NEXT:    add %i0, 2175, %i0
; CHECK64-NEXT:    and %i0, -64, %o1
; CHECK64-NEXT:    add %o1, -2175, %sp
; CHECK64-NEXT:    add %sp, -48, %sp
; CHECK64-NEXT:    call foo
; CHECK64-NEXT:    mov %g0, %o0
; CHECK64-NEXT:    add %sp, 48, %sp
; CHECK64-NEXT:    ret
; CHECK64-NEXT:    restore
  %var_size = alloca i8, i32 %num, align 64
  call void @foo(ptr null, ptr %var_size)
  ret void
}

declare void @foo(ptr, ptr);
