; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s

define i128 @test_R_wide_scalar_simple(i128 noundef %0) nounwind {
; CHECK-LABEL: test_R_wide_scalar_simple:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # a2 <- a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    ret
entry:
  %1 = call i128 asm sideeffect "/* $0 <- $1 */", "=&R,R"(i128 %0)
  ret i128 %1
}

define i64 @test_R_wide_scalar_with_ops(i64 noundef %0) nounwind {
; CHECK-LABEL: test_R_wide_scalar_with_ops:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # a2 <- a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    or a0, a2, a3
; CHECK-NEXT:    ret
entry:
  %1 = zext i64 %0 to i128
  %2 = shl i128 %1, 64
  %3 = or i128 %1, %2
  %4 = call i128 asm sideeffect "/* $0 <- $1 */", "=&R,R"(i128 %3)
  %5 = trunc i128 %4 to i64
  %6 = lshr i128 %4, 64
  %7 = trunc i128 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define i128 @test_R_wide_scalar_inout(ptr %0, i128 noundef %1) nounwind {
; CHECK-LABEL: test_R_wide_scalar_inout:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    mv a3, a2
; CHECK-NEXT:    sd a0, 24(sp)
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    sd a1, 0(sp)
; CHECK-NEXT:    sd a3, 8(sp)
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # a0; a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sd a0, 24(sp)
; CHECK-NEXT:    sd a2, 0(sp)
; CHECK-NEXT:    sd a3, 8(sp)
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %2 = alloca ptr, align 8
  %3 = alloca i128, align 16
  store ptr %0, ptr %2, align 8
  store i128 %1, ptr %3, align 16
  %4 = load ptr, ptr %2, align 8
  %5 = load i128, ptr %3, align 16
  %6 = call { ptr, i128 } asm sideeffect "/* $0; $1 */", "=r,=R,0,1"(ptr %4, i128 %5)
  %7 = extractvalue { ptr, i128} %6, 0
  %8 = extractvalue { ptr, i128 } %6, 1
  store ptr %7, ptr %2, align 8
  store i128 %8, ptr %3, align 16
  %9 = load i128, ptr %3, align 16
  ret i128 %9
}

define i128 @test_cR_wide_scalar_simple(i128 noundef %0) nounwind {
; CHECK-LABEL: test_cR_wide_scalar_simple:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # a2 <- a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    ret
entry:
  %1 = call i128 asm sideeffect "/* $0 <- $1 */", "=&^cR,^cR"(i128 %0)
  ret i128 %1
}

define i64 @test_cR_wide_scalar_with_ops(i64 noundef %0) nounwind {
; CHECK-LABEL: test_cR_wide_scalar_with_ops:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # a2 <- a0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    or a0, a2, a3
; CHECK-NEXT:    ret
entry:
  %1 = zext i64 %0 to i128
  %2 = shl i128 %1, 64
  %3 = or i128 %1, %2
  %4 = call i128 asm sideeffect "/* $0 <- $1 */", "=&^cR,^cR"(i128 %3)
  %5 = trunc i128 %4 to i64
  %6 = lshr i128 %4, 64
  %7 = trunc i128 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define i128 @test_cR_wide_scalar_inout(ptr %0, i128 noundef %1) nounwind {
; CHECK-LABEL: test_cR_wide_scalar_inout:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    mv a3, a2
; CHECK-NEXT:    sd a0, 24(sp)
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    sd a1, 0(sp)
; CHECK-NEXT:    sd a3, 8(sp)
; CHECK-NEXT:    #APP
; CHECK-NEXT:    # a0; a2
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    sd a0, 24(sp)
; CHECK-NEXT:    sd a2, 0(sp)
; CHECK-NEXT:    sd a3, 8(sp)
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %2 = alloca ptr, align 8
  %3 = alloca i128, align 16
  store ptr %0, ptr %2, align 8
  store i128 %1, ptr %3, align 16
  %4 = load ptr, ptr %2, align 8
  %5 = load i128, ptr %3, align 16
  %6 = call { ptr, i128 } asm sideeffect "/* $0; $1 */", "=r,=^cR,0,1"(ptr %4, i128 %5)
  %7 = extractvalue { ptr, i128} %6, 0
  %8 = extractvalue { ptr, i128 } %6, 1
  store ptr %7, ptr %2, align 8
  store i128 %8, ptr %3, align 16
  %9 = load i128, ptr %3, align 16
  ret i128 %9
}
