; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-linux-gnu < %s \
; RUN:   -stop-after=finalize-isel -verify-machineinstrs | FileCheck %s
define i64 @load(ptr %p) {
  ; CHECK-LABEL: name: load
  ; CHECK: bb.0.entry:
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:g8rc_and_g8rc_nox0 = COPY $x3
  ; CHECK:   [[LD:%[0-9]+]]:g8rc = LD 24, [[COPY]] :: (load (s64) from %ir.arrayidx, align 2)
  ; CHECK:   $x3 = COPY [[LD]]
  ; CHECK:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %arrayidx = getelementptr inbounds i64, ptr %p, i64 3
  %0 = load i64, ptr %arrayidx, align 2
  ret i64 %0
}

define void @store(ptr %p) {
  ; CHECK-LABEL: name: store
  ; CHECK: bb.0.entry:
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:g8rc_and_g8rc_nox0 = COPY $x3
  ; CHECK:   [[LI8_:%[0-9]+]]:g8rc = LI8 9
  ; CHECK:   STD killed [[LI8_]], 16, [[COPY]] :: (store (s64) into %ir.arrayidx, align 1)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
entry:
  %arrayidx = getelementptr inbounds i64, ptr %p, i64 2
  store i64 9, ptr %arrayidx, align 1
  ret void
}

define void @store_aligned(ptr %p) {
  ; CHECK-LABEL: name: store_aligned
  ; CHECK: bb.0.entry:
  ; CHECK:   liveins: $x3
  ; CHECK:   [[COPY:%[0-9]+]]:g8rc_and_g8rc_nox0 = COPY $x3
  ; CHECK:   [[LI8_:%[0-9]+]]:g8rc = LI8 9
  ; CHECK:   STD killed [[LI8_]], 16, [[COPY]] :: (store (s64) into %ir.arrayidx, align 4)
  ; CHECK:   BLR8 implicit $lr8, implicit $rm
entry:
  %arrayidx = getelementptr inbounds i64, ptr %p, i64 2
  store i64 9, ptr %arrayidx, align 4
  ret void
}
