; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S < %s | FileCheck %s

; Make sure that opaque pointer intrinsic remangling upgrade works.

%int8x16x2_t = type { <16 x i8>, <16 x i8> }

declare ptr @fake_personality_function()
declare void @func()

; Upgrading of invoked intrinsic.
define void @test_invoke(ptr addrspace(1) %b) gc "statepoint-example" personality ptr @fake_personality_function {
; CHECK-LABEL: @test_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[D:%.*]] = getelementptr i32, ptr addrspace(1) [[B:%.*]], i64 16
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"(ptr addrspace(1) [[B]], ptr addrspace(1) [[B]], ptr addrspace(1) [[D]], ptr addrspace(1) [[D]]) ]
; CHECK-NEXT:    to label [[NORMAL_DEST:%.*]] unwind label [[UNWIND_DEST:%.*]]
; CHECK:       normal_dest:
; CHECK-NEXT:    ret void
; CHECK:       unwind_dest:
; CHECK-NEXT:    [[LPAD:%.*]] = landingpad token
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret void
;
entry:
  %d = getelementptr i32, ptr addrspace(1) %b, i64 16
  %safepoint_token = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live" (ptr addrspace(1) %b, ptr addrspace(1) %b, ptr addrspace(1) %d, ptr addrspace(1) %d)]
  to label %normal_dest unwind label %unwind_dest

normal_dest:
  ret void

unwind_dest:
  %lpad = landingpad token
  cleanup
  ret void
}

define ptr @test_ptr_annotation(ptr %p) {
; CHECK-LABEL: @test_ptr_annotation(
; CHECK-NEXT:    [[P2:%.*]] = call ptr @llvm.ptr.annotation.p0.p0(ptr [[P:%.*]], ptr undef, ptr undef, i32 undef, ptr undef)
; CHECK-NEXT:    ret ptr [[P2]]
;
  %p2 = call ptr @llvm.ptr.annotation.p0(ptr %p, ptr undef, ptr undef, i32 undef, ptr undef)
  ret ptr %p2
}


define void @test_struct_return(ptr %res.p, ptr %a) {
; CHECK-LABEL: @test_struct_return(
; CHECK-NEXT:    [[TMP1:%.*]] = call { <16 x i8>, <16 x i8> } @llvm.aarch64.neon.ld1x2.v16i8.p0(ptr [[A:%.*]])
; CHECK-NEXT:    [[TMP2:%.*]] = extractvalue { <16 x i8>, <16 x i8> } [[TMP1]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = insertvalue [[INT8X16X2_T:%.*]] poison, <16 x i8> [[TMP2]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { <16 x i8>, <16 x i8> } [[TMP1]], 1
; CHECK-NEXT:    [[TMP5:%.*]] = insertvalue [[INT8X16X2_T]] [[TMP3]], <16 x i8> [[TMP4]], 1
; CHECK-NEXT:    store [[INT8X16X2_T]] [[TMP5]], ptr [[RES_P:%.*]], align 16
; CHECK-NEXT:    ret void
;
  %res = call %int8x16x2_t @llvm.aarch64.neon.ld1x2.v16i8.p0(ptr %a)
  store %int8x16x2_t %res, ptr %res.p
  ret void
}

declare token @llvm.experimental.gc.statepoint.p0(i64, i32, ptr, i32, i32, ...)
declare ptr @llvm.ptr.annotation.p0(ptr, ptr, ptr, i32, ptr)
declare %int8x16x2_t @llvm.aarch64.neon.ld1x2.v16i8.p0(ptr)
