; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse3 | FileCheck %s --check-prefixes=SSE3
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+xop,+avx | FileCheck %s -check-prefixes=XOPAVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+xop,+avx2 | FileCheck %s -check-prefixes=XOPAVX2
;
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=goldmont | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1

define i32 @cmp_int_eq(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_eq'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_eq'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_eq'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_eq'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_eq'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_eq'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_eq'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_eq'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_eq'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_eq'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_eq'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_eq'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp eq i8 %arg8, zeroinitializer
  %V16I8 = icmp eq <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp eq <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp eq <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp eq <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp eq i16 %arg16, zeroinitializer
  %V8I16  = icmp eq <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp eq <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp eq <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp eq <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp eq i32 %arg32, zeroinitializer
  %V4I32 = icmp eq <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp eq <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp eq <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp eq <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp eq i64 %arg64, zeroinitializer
  %V2I64 = icmp eq <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp eq <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp eq <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp eq <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_ne(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ne'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ne'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ne'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ne'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ne'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ne'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ne'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ne'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ne'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ne'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ne'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ne'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ne i8 %arg8, zeroinitializer
  %V16I8 = icmp ne <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp ne <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp ne <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp ne <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp ne i16 %arg16, zeroinitializer
  %V8I16  = icmp ne <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp ne <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp ne <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp ne <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp ne i32 %arg32, zeroinitializer
  %V4I32 = icmp ne <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp ne <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp ne <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp ne <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp ne i64 %arg64, zeroinitializer
  %V2I64 = icmp ne <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp ne <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp ne <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp ne <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_sge(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sge'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_sge'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_sge'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_sge'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sge'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sge'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sge'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sge'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sge'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sge'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sge'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_sge'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp sge i8 %arg8, zeroinitializer
  %V16I8 = icmp sge <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp sge <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp sge <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp sge <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp sge i16 %arg16, zeroinitializer
  %V8I16  = icmp sge <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp sge <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp sge <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp sge <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp sge i32 %arg32, zeroinitializer
  %V4I32 = icmp sge <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp sge <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp sge <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp sge <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp sge i64 %arg64, zeroinitializer
  %V2I64 = icmp sge <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp sge <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp sge <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp sge <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_uge(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_uge'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_uge'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_uge'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_uge'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_uge'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:8 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:16 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:32 SizeLat:32 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_uge'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_uge'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_uge'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_uge'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_uge'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_uge'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_uge'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:4 for: %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:6 Lat:14 SizeLat:8 for: %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:12 Lat:28 SizeLat:16 for: %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:24 Lat:56 SizeLat:32 for: %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp uge i8 %arg8, zeroinitializer
  %V16I8 = icmp uge <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp uge <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp uge <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp uge <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp uge i16 %arg16, zeroinitializer
  %V8I16  = icmp uge <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp uge <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp uge <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp uge <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp uge i32 %arg32, zeroinitializer
  %V4I32 = icmp uge <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp uge <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp uge <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp uge <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp uge i64 %arg64, zeroinitializer
  %V2I64 = icmp uge <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp uge <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp uge <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp uge <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_sgt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sgt'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_sgt'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_sgt'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_sgt'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sgt'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sgt'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sgt'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sgt'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sgt'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sgt'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sgt'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_sgt'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp sgt i8 %arg8, zeroinitializer
  %V16I8 = icmp sgt <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp sgt <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp sgt <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp sgt <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp sgt i16 %arg16, zeroinitializer
  %V8I16  = icmp sgt <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp sgt <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp sgt <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp sgt <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp sgt i32 %arg32, zeroinitializer
  %V4I32 = icmp sgt <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp sgt <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp sgt <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp sgt <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp sgt i64 %arg64, zeroinitializer
  %V2I64 = icmp sgt <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp sgt <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp sgt <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp sgt <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_ugt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ugt'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ugt'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ugt'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ugt'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ugt'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:24 SizeLat:24 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ugt'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ugt'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ugt'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ugt'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ugt'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ugt'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ugt'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:3 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:6 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:24 SizeLat:12 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:48 SizeLat:24 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ugt i8 %arg8, zeroinitializer
  %V16I8 = icmp ugt <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp ugt <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp ugt <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp ugt <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp ugt i16 %arg16, zeroinitializer
  %V8I16  = icmp ugt <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp ugt <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp ugt <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp ugt <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp ugt i32 %arg32, zeroinitializer
  %V4I32 = icmp ugt <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp ugt <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp ugt <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp ugt <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp ugt i64 %arg64, zeroinitializer
  %V2I64 = icmp ugt <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp ugt <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp ugt <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp ugt <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_sle(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sle'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_sle'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_sle'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_sle'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sle'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sle'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sle'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sle'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sle'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sle'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sle'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_sle'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp sle i8 %arg8, zeroinitializer
  %V16I8 = icmp sle <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp sle <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp sle <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp sle <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp sle i16 %arg16, zeroinitializer
  %V8I16  = icmp sle <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp sle <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp sle <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp sle <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp sle i32 %arg32, zeroinitializer
  %V4I32 = icmp sle <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp sle <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp sle <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp sle <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp sle i64 %arg64, zeroinitializer
  %V2I64 = icmp sle <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp sle <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp sle <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp sle <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_ule(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ule'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ule'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ule'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ule'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ule'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:8 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:16 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:32 SizeLat:32 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ule'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ule'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ule'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ule'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ule'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ule'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ule'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:4 for: %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:6 Lat:14 SizeLat:8 for: %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:12 Lat:28 SizeLat:16 for: %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:24 Lat:56 SizeLat:32 for: %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ule i8 %arg8, zeroinitializer
  %V16I8 = icmp ule <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp ule <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp ule <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp ule <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp ule i16 %arg16, zeroinitializer
  %V8I16  = icmp ule <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp ule <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp ule <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp ule <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp ule i32 %arg32, zeroinitializer
  %V4I32 = icmp ule <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp ule <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp ule <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp ule <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp ule i64 %arg64, zeroinitializer
  %V2I64 = icmp ule <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp ule <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp ule <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp ule <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_slt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_slt'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_slt'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_slt'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_slt'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_slt'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_slt'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_slt'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_slt'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_slt'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_slt'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_slt'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_slt'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp slt i8 %arg8, zeroinitializer
  %V16I8 = icmp slt <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp slt <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp slt <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp slt <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp slt i16 %arg16, zeroinitializer
  %V8I16  = icmp slt <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp slt <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp slt <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp slt <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp slt i32 %arg32, zeroinitializer
  %V4I32 = icmp slt <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp slt <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp slt <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp slt <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp slt i64 %arg64, zeroinitializer
  %V2I64 = icmp slt <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp slt <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp slt <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp slt <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

define i32 @cmp_int_ult(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ult'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ult'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; SSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ult'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ult'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; SSE41-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ult'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:24 SizeLat:24 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ult'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ult'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ult'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ult'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ult'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ult'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ult'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ult <8 x i16> %argv8i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, 0
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, 0
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:3 for: %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:6 for: %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:24 SizeLat:12 for: %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:48 SizeLat:24 for: %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ult i8 %arg8, zeroinitializer
  %V16I8 = icmp ult <16 x i8> %argv16i8, zeroinitializer
  %V32I8 = icmp ult <32 x i8> %argv32i8, zeroinitializer
  %V64I8 = icmp ult <64 x i8> %argv64i8, zeroinitializer
  %V128I8 = icmp ult <128 x i8> %argv128i8, zeroinitializer

  %I16 = icmp ult i16 %arg16, zeroinitializer
  %V8I16  = icmp ult <8 x i16> %argv8i16, zeroinitializer
  %V16I16 = icmp ult <16 x i16> %argv16i16, zeroinitializer
  %V32I16 = icmp ult <32 x i16> %argv32i16, zeroinitializer
  %V64I16 = icmp ult <64 x i16> %argv64i16, zeroinitializer

  %I32 = icmp ult i32 %arg32, zeroinitializer
  %V4I32 = icmp ult <4 x i32> %argv4i32, zeroinitializer
  %V8I32 = icmp ult <8 x i32> %argv8i32, zeroinitializer
  %V16I32 = icmp ult <16 x i32> %argv16i32, zeroinitializer
  %V32I32 = icmp ult <32 x i32> %argv32i32, zeroinitializer

  %I64 = icmp ult i64 %arg64, zeroinitializer
  %V2I64 = icmp ult <2 x i64> %argv2i64, zeroinitializer
  %V4I64 = icmp ult <4 x i64> %argv4i64, zeroinitializer
  %V8I64 = icmp ult <8 x i64> %argv8i64, zeroinitializer
  %V16I64 = icmp ult <16 x i64> %argv16i64, zeroinitializer

  ret i32 undef
}

