; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-darwin -mattr=+mmx,+sse2 | FileCheck %s

define i64 @t0(ptr %p) {
; CHECK-LABEL: t0:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movq (%rdi), %mm0
; CHECK-NEXT:    paddq %mm0, %mm0
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %t = load <1 x i64>, ptr %p
  %u = tail call <1 x i64> @llvm.x86.mmx.padd.q(<1 x i64> %t, <1 x i64> %t)
  %s = bitcast <1 x i64> %u to i64
  ret i64 %s
}

define i64 @t1(ptr %p) {
; CHECK-LABEL: t1:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movq (%rdi), %mm0
; CHECK-NEXT:    paddd %mm0, %mm0
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %t = load <1 x i64>, ptr %p
  %u = tail call <1 x i64> @llvm.x86.mmx.padd.d(<1 x i64> %t, <1 x i64> %t)
  %s = bitcast <1 x i64> %u to i64
  ret i64 %s
}

define i64 @t2(ptr %p) {
; CHECK-LABEL: t2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movq (%rdi), %mm0
; CHECK-NEXT:    paddw %mm0, %mm0
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %t = load <1 x i64>, ptr %p
  %u = tail call <1 x i64> @llvm.x86.mmx.padd.w(<1 x i64> %t, <1 x i64> %t)
  %s = bitcast <1 x i64> %u to i64
  ret i64 %s
}

define i64 @t3(ptr %p) {
; CHECK-LABEL: t3:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movq (%rdi), %mm0
; CHECK-NEXT:    paddb %mm0, %mm0
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %t = load <1 x i64>, ptr %p
  %u = tail call <1 x i64> @llvm.x86.mmx.padd.b(<1 x i64> %t, <1 x i64> %t)
  %s = bitcast <1 x i64> %u to i64
  ret i64 %s
}

@R = external global <1 x i64>

define void @t4(<1 x i64> %A, <1 x i64> %B) {
; CHECK-LABEL: t4:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddusw %mm0, %mm1
; CHECK-NEXT:    movq _R@GOTPCREL(%rip), %rax
; CHECK-NEXT:    movq %mm1, (%rax)
; CHECK-NEXT:    emms
; CHECK-NEXT:    retq
entry:
  %tmp7 = tail call <1 x i64> @llvm.x86.mmx.paddus.w(<1 x i64> %A, <1 x i64> %B)
  store <1 x i64> %tmp7, ptr @R
  tail call void @llvm.x86.mmx.emms()
  ret void
}

define i64 @t5(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: t5:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movd %esi, %xmm0
; CHECK-NEXT:    movd %edi, %xmm1
; CHECK-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-NEXT:    movq %xmm1, %rax
; CHECK-NEXT:    retq
  %v0 = insertelement <2 x i32> undef, i32 %a, i32 0
  %v1 = insertelement <2 x i32> %v0, i32 %b, i32 1
  %conv = bitcast <2 x i32> %v1 to i64
  ret i64 %conv
}

declare <1 x i64> @llvm.x86.mmx.pslli.q(<1 x i64>, i32)

define <1 x i64> @t6(i64 %t) {
; CHECK-LABEL: t6:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    psllq $48, %mm0
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %t1 = insertelement <1 x i64> undef, i64 %t, i32 0
  %t2 = tail call <1 x i64> @llvm.x86.mmx.pslli.q(<1 x i64> %t1, i32 48)
  ret <1 x i64> %t2
}

declare <1 x i64> @llvm.x86.mmx.paddus.w(<1 x i64>, <1 x i64>)
declare <1 x i64> @llvm.x86.mmx.padd.b(<1 x i64>, <1 x i64>)
declare <1 x i64> @llvm.x86.mmx.padd.w(<1 x i64>, <1 x i64>)
declare <1 x i64> @llvm.x86.mmx.padd.d(<1 x i64>, <1 x i64>)
declare <1 x i64> @llvm.x86.mmx.padd.q(<1 x i64>, <1 x i64>)
declare void @llvm.x86.mmx.emms()

