; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-unroll -mcpu=apple-m1 -S %s | FileCheck --check-prefix=APPLE %s
; RUN: opt -p loop-unroll -mcpu=apple-m2 -S %s | FileCheck --check-prefix=APPLE %s
; RUN: opt -p loop-unroll -mcpu=apple-m3 -S %s | FileCheck --check-prefix=APPLE %s
; RUN: opt -p loop-unroll -mcpu=apple-m4 -S %s | FileCheck --check-prefix=APPLE %s
; RUN: opt -p loop-unroll -mcpu=cortex-a57 -S %s | FileCheck --check-prefix=OTHER %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "arm64-apple-macosx15.0.0"

define i1 @multi_2_exit_find_i8_loop(ptr %vec, i8 %tgt) {
; APPLE-LABEL: define i1 @multi_2_exit_find_i8_loop(
; APPLE-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0:[0-9]+]] {
; APPLE-NEXT:  [[ENTRY:.*]]:
; APPLE-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; APPLE-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; APPLE-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; APPLE-NEXT:    br label %[[LOOP_HEADER:.*]]
; APPLE:       [[LOOP_HEADER]]:
; APPLE-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; APPLE-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; APPLE-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; APPLE-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; APPLE:       [[LOOP_LATCH]]:
; APPLE-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; APPLE-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; APPLE-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; APPLE:       [[EXIT]]:
; APPLE-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; APPLE-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; APPLE-NEXT:    ret i1 [[C_3]]
;
; OTHER-LABEL: define i1 @multi_2_exit_find_i8_loop(
; OTHER-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0:[0-9]+]] {
; OTHER-NEXT:  [[ENTRY:.*]]:
; OTHER-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; OTHER-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; OTHER-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; OTHER-NEXT:    br label %[[LOOP_HEADER:.*]]
; OTHER:       [[LOOP_HEADER]]:
; OTHER-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; OTHER-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; OTHER-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; OTHER-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; OTHER:       [[LOOP_LATCH]]:
; OTHER-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; OTHER-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; OTHER-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; OTHER:       [[EXIT]]:
; OTHER-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; OTHER-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; OTHER-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  %c.1 = icmp eq i8 %l, %tgt
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}


define i1 @multi_2_exit_find_ptr_loop(ptr %vec, ptr %tgt) {
; APPLE-LABEL: define i1 @multi_2_exit_find_ptr_loop(
; APPLE-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]]) #[[ATTR0]] {
; APPLE-NEXT:  [[ENTRY:.*]]:
; APPLE-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; APPLE-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; APPLE-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; APPLE-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; APPLE-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; APPLE-NEXT:    br label %[[LOOP_HEADER:.*]]
; APPLE:       [[LOOP_HEADER]]:
; APPLE-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; APPLE-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; APPLE-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; APPLE-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; APPLE:       [[LOOP_LATCH]]:
; APPLE-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; APPLE-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; APPLE-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; APPLE:       [[EXIT]]:
; APPLE-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; APPLE-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; APPLE-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; APPLE-NEXT:    ret i1 [[C_3]]
;
; OTHER-LABEL: define i1 @multi_2_exit_find_ptr_loop(
; OTHER-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]]) #[[ATTR0]] {
; OTHER-NEXT:  [[ENTRY:.*]]:
; OTHER-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; OTHER-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; OTHER-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; OTHER-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; OTHER-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; OTHER-NEXT:    br label %[[LOOP_HEADER:.*]]
; OTHER:       [[LOOP_HEADER]]:
; OTHER-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; OTHER-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; OTHER-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; OTHER-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; OTHER:       [[LOOP_LATCH]]:
; OTHER-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; OTHER-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; OTHER-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; OTHER:       [[EXIT]]:
; OTHER-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; OTHER-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; OTHER-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; OTHER-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %start, i64 8) ]
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 8
  %end = load ptr, ptr %gep.end, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load ptr, ptr %ptr.iv, align 8
  %c.1 = icmp eq ptr %l, %tgt
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 8
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}

define i1 @multi_2_exit_find_i8_loop_too_large(ptr %vec, i8 %tgt) {
; APPLE-LABEL: define i1 @multi_2_exit_find_i8_loop_too_large(
; APPLE-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; APPLE-NEXT:  [[ENTRY:.*]]:
; APPLE-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; APPLE-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; APPLE-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; APPLE-NEXT:    br label %[[LOOP_HEADER:.*]]
; APPLE:       [[LOOP_HEADER]]:
; APPLE-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; APPLE-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; APPLE-NEXT:    [[UDIV:%.*]] = udiv i8 [[L]], [[TGT]]
; APPLE-NEXT:    [[UDIV_2:%.*]] = udiv i8 [[UDIV]], 10
; APPLE-NEXT:    [[C_1:%.*]] = icmp eq i8 [[UDIV_2]], 2
; APPLE-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; APPLE:       [[LOOP_LATCH]]:
; APPLE-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; APPLE-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; APPLE-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; APPLE:       [[EXIT]]:
; APPLE-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; APPLE-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; APPLE-NEXT:    ret i1 [[C_3]]
;
; OTHER-LABEL: define i1 @multi_2_exit_find_i8_loop_too_large(
; OTHER-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; OTHER-NEXT:  [[ENTRY:.*]]:
; OTHER-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; OTHER-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; OTHER-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; OTHER-NEXT:    br label %[[LOOP_HEADER:.*]]
; OTHER:       [[LOOP_HEADER]]:
; OTHER-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; OTHER-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; OTHER-NEXT:    [[UDIV:%.*]] = udiv i8 [[L]], [[TGT]]
; OTHER-NEXT:    [[UDIV_2:%.*]] = udiv i8 [[UDIV]], 10
; OTHER-NEXT:    [[C_1:%.*]] = icmp eq i8 [[UDIV_2]], 2
; OTHER-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; OTHER:       [[LOOP_LATCH]]:
; OTHER-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; OTHER-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; OTHER-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; OTHER:       [[EXIT]]:
; OTHER-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; OTHER-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; OTHER-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  %udiv = udiv i8 %l, %tgt
  %udiv.2 = udiv i8 %udiv, 10
  %c.1 = icmp eq i8 %udiv.2, 2
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}
define i1 @multi_3_exit_find_ptr_loop(ptr %vec, ptr %tgt, ptr %tgt2) {
; APPLE-LABEL: define i1 @multi_3_exit_find_ptr_loop(
; APPLE-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]], ptr [[TGT2:%.*]]) #[[ATTR0]] {
; APPLE-NEXT:  [[ENTRY:.*]]:
; APPLE-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; APPLE-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; APPLE-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; APPLE-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; APPLE-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; APPLE-NEXT:    br label %[[LOOP_HEADER:.*]]
; APPLE:       [[LOOP_HEADER]]:
; APPLE-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; APPLE-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; APPLE-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; APPLE-NEXT:    [[C_2:%.*]] = icmp eq ptr [[L]], [[TGT2]]
; APPLE-NEXT:    [[OR_COND:%.*]] = select i1 [[C_1]], i1 true, i1 [[C_2]]
; APPLE-NEXT:    br i1 [[OR_COND]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; APPLE:       [[LOOP_LATCH]]:
; APPLE-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; APPLE-NEXT:    [[C_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; APPLE-NEXT:    br i1 [[C_3]], label %[[EXIT]], label %[[LOOP_HEADER]]
; APPLE:       [[EXIT]]:
; APPLE-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; APPLE-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; APPLE-NEXT:    [[C_4:%.*]] = icmp eq ptr [[RES]], [[END]]
; APPLE-NEXT:    ret i1 [[C_4]]
;
; OTHER-LABEL: define i1 @multi_3_exit_find_ptr_loop(
; OTHER-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]], ptr [[TGT2:%.*]]) #[[ATTR0]] {
; OTHER-NEXT:  [[ENTRY:.*]]:
; OTHER-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; OTHER-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; OTHER-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; OTHER-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; OTHER-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; OTHER-NEXT:    br label %[[LOOP_HEADER:.*]]
; OTHER:       [[LOOP_HEADER]]:
; OTHER-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; OTHER-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; OTHER-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; OTHER-NEXT:    [[C_2:%.*]] = icmp eq ptr [[L]], [[TGT2]]
; OTHER-NEXT:    [[OR_COND:%.*]] = select i1 [[C_1]], i1 true, i1 [[C_2]]
; OTHER-NEXT:    br i1 [[OR_COND]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; OTHER:       [[LOOP_LATCH]]:
; OTHER-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; OTHER-NEXT:    [[C_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; OTHER-NEXT:    br i1 [[C_3]], label %[[EXIT]], label %[[LOOP_HEADER]]
; OTHER:       [[EXIT]]:
; OTHER-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; OTHER-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; OTHER-NEXT:    [[C_4:%.*]] = icmp eq ptr [[RES]], [[END]]
; OTHER-NEXT:    ret i1 [[C_4]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %start, i64 8) ]
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 8
  %end = load ptr, ptr %gep.end, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load ptr, ptr %ptr.iv, align 8
  %c.1 = icmp eq ptr %l, %tgt
  br i1 %c.1, label %exit, label %then

then:
  %c.2 = icmp eq ptr %l, %tgt2
  br i1 %c.2, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 8
  %c.3 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.3, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %ptr.iv, %then], [ %end, %loop.latch ]
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  %c.4 = icmp eq ptr %res, %end
  ret i1 %c.4
}

define i1 @multi_3_exit_find_i8_loop_switch(ptr %vec, i8 %tgt) {
; APPLE-LABEL: define i1 @multi_3_exit_find_i8_loop_switch(
; APPLE-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; APPLE-NEXT:  [[ENTRY:.*]]:
; APPLE-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; APPLE-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; APPLE-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; APPLE-NEXT:    br label %[[LOOP_HEADER:.*]]
; APPLE:       [[LOOP_HEADER]]:
; APPLE-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; APPLE-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; APPLE-NEXT:    switch i8 [[L]], label %[[LOOP_LATCH]] [
; APPLE-NEXT:      i8 0, label %[[EXIT_1:.*]]
; APPLE-NEXT:      i8 1, label %[[EXIT_2:.*]]
; APPLE-NEXT:      i8 2, label %[[EXIT:.*]]
; APPLE-NEXT:    ]
; APPLE:       [[LOOP_LATCH]]:
; APPLE-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; APPLE-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; APPLE-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; APPLE:       [[EXIT]]:
; APPLE-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; APPLE-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; APPLE-NEXT:    ret i1 [[C_3]]
; APPLE:       [[EXIT_1]]:
; APPLE-NEXT:    ret i1 false
; APPLE:       [[EXIT_2]]:
; APPLE-NEXT:    ret i1 true
;
; OTHER-LABEL: define i1 @multi_3_exit_find_i8_loop_switch(
; OTHER-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; OTHER-NEXT:  [[ENTRY:.*]]:
; OTHER-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; OTHER-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; OTHER-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; OTHER-NEXT:    br label %[[LOOP_HEADER:.*]]
; OTHER:       [[LOOP_HEADER]]:
; OTHER-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; OTHER-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; OTHER-NEXT:    switch i8 [[L]], label %[[LOOP_LATCH]] [
; OTHER-NEXT:      i8 0, label %[[EXIT_1:.*]]
; OTHER-NEXT:      i8 1, label %[[EXIT_2:.*]]
; OTHER-NEXT:      i8 2, label %[[EXIT:.*]]
; OTHER-NEXT:    ]
; OTHER:       [[LOOP_LATCH]]:
; OTHER-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; OTHER-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; OTHER-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; OTHER:       [[EXIT]]:
; OTHER-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; OTHER-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; OTHER-NEXT:    ret i1 [[C_3]]
; OTHER:       [[EXIT_1]]:
; OTHER-NEXT:    ret i1 false
; OTHER:       [[EXIT_2]]:
; OTHER-NEXT:    ret i1 true
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  switch i8 %l, label %loop.latch [
  i8 0, label %exit.1
  i8 1, label %exit.2
  i8 2, label %exit ]

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3

exit.1:
  ret i1 0

exit.2:
  ret i1 1
}

declare void @llvm.assume(i1 noundef)
