; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Instcombine should be able to eliminate the lshr, because only
; bits in the operand which might be non-zero will be shifted
; off the end.

define i32 @hash_string(ptr nocapture %key) nounwind readonly {
; CHECK-LABEL: @hash_string(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[T0:%.*]] = load i8, ptr [[KEY:%.*]], align 1
; CHECK-NEXT:    [[T1:%.*]] = icmp eq i8 [[T0]], 0
; CHECK-NEXT:    br i1 [[T1]], label [[BB2:%.*]], label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[T:%.*]], [[BB]] ]
; CHECK-NEXT:    [[K_04:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[T8:%.*]], [[BB]] ]
; CHECK-NEXT:    [[CP_05:%.*]] = getelementptr i8, ptr [[KEY]], i64 [[INDVAR]]
; CHECK-NEXT:    [[T2:%.*]] = shl nuw nsw i32 [[K_04]], 1
; CHECK-NEXT:    [[T5:%.*]] = load i8, ptr [[CP_05]], align 1
; CHECK-NEXT:    [[T6:%.*]] = sext i8 [[T5]] to i32
; CHECK-NEXT:    [[T7:%.*]] = xor i32 [[T2]], [[T6]]
; CHECK-NEXT:    [[T8]] = and i32 [[T7]], 16383
; CHECK-NEXT:    [[T]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[KEY]], i64 [[T]]
; CHECK-NEXT:    [[T9:%.*]] = load i8, ptr [[SCEVGEP]], align 1
; CHECK-NEXT:    [[T10:%.*]] = icmp eq i8 [[T9]], 0
; CHECK-NEXT:    br i1 [[T10]], label [[BB2]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    [[K_0_LCSSA:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[T8]], [[BB]] ]
; CHECK-NEXT:    ret i32 [[K_0_LCSSA]]
;
entry:
  %t0 = load i8, ptr %key, align 1
  %t1 = icmp eq i8 %t0, 0
  br i1 %t1, label %bb2, label %bb

bb:
  %indvar = phi i64 [ 0, %entry ], [ %t, %bb ]
  %k.04 = phi i32 [ 0, %entry ], [ %t8, %bb ]
  %cp.05 = getelementptr i8, ptr %key, i64 %indvar
  %t2 = shl i32 %k.04, 1
  %t3 = lshr i32 %k.04, 14
  %t4 = add i32 %t2, %t3
  %t5 = load i8, ptr %cp.05, align 1
  %t6 = sext i8 %t5 to i32
  %t7 = xor i32 %t6, %t4
  %t8 = and i32 %t7, 16383
  %t = add i64 %indvar, 1
  %scevgep = getelementptr i8, ptr %key, i64 %t
  %t9 = load i8, ptr %scevgep, align 1
  %t10 = icmp eq i8 %t9, 0
  br i1 %t10, label %bb2, label %bb

bb2:
  %k.0.lcssa = phi i32 [ 0, %entry ], [ %t8, %bb ]
  ret i32 %k.0.lcssa
}
