; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.1 | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s

define i16 @mulhs(i16 %a0, i16 %a1) {
; CHECK-LABEL: mulhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movswl %di, %ecx
; CHECK-NEXT:    movswl %si, %eax
; CHECK-NEXT:    imull %ecx, %eax
; CHECK-NEXT:    shrl $16, %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %x0 = sext i16 %a0 to i32
    %x1 = sext i16 %a1 to i32
    %v0 = insertelement <1 x i32> <i32 undef>, i32 %x0, i32 0
    %v1 = insertelement <1 x i32> <i32 undef>, i32 %x1, i32 0
    %mul = mul nsw <1 x i32> %v0, %v1
    %lshr = lshr <1 x i32> %mul, <i32 16>
    %trunc = trunc <1 x i32> %lshr to <1 x i16>
    %res = extractelement <1 x i16> %trunc, i32 0
    ret i16 %res
}

define i16 @mulhu(i16 %a0, i16 %a1) {
; CHECK-LABEL: mulhu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movzwl %di, %ecx
; CHECK-NEXT:    movzwl %si, %eax
; CHECK-NEXT:    imull %ecx, %eax
; CHECK-NEXT:    shrl $16, %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %x0 = zext i16 %a0 to i32
    %x1 = zext i16 %a1 to i32
    %v0 = insertelement <1 x i32> <i32 undef>, i32 %x0, i32 0
    %v1 = insertelement <1 x i32> <i32 undef>, i32 %x1, i32 0
    %mul = mul nsw <1 x i32> %v0, %v1
    %lshr = lshr <1 x i32> %mul, <i32 16>
    %trunc = trunc <1 x i32> %lshr to <1 x i16>
    %res = extractelement <1 x i16> %trunc, i32 0
    ret i16 %res
}
