/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.sf.jasperreports.engine.JRRuntimeException;

public class Base64Util {
    public static final Integer DEFAULT_LINE_LENGTH = 76;
    public static final byte[] DEFAULT_LINE_SEPARATOR = "\n".getBytes();

    public static void decode(InputStream in, OutputStream out) throws IOException {
        InputStream base64in = Base64.getMimeDecoder().wrap(in);
        Base64Util.copy(base64in, out);
    }

    public static byte[] decode(String data) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(data.getBytes(StandardCharsets.US_ASCII));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64Util.decode(input, out);
        return out.toByteArray();
    }

    public static void encode(InputStream in, OutputStream out) throws IOException {
        Base64Util.encode(in, out, true);
    }

    public static void encode(InputStream in, OutputStream out, boolean multiLineOutput) throws IOException {
        Base64.Encoder encoder = multiLineOutput ? Base64.getMimeEncoder(DEFAULT_LINE_LENGTH, DEFAULT_LINE_SEPARATOR) : Base64.getMimeEncoder();
        OutputStream base64out = encoder.wrap(out);
        Base64Util.copy(in, base64out);
        base64out.close();
    }

    public static String encode(byte[] data, boolean multiLineOutput) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Base64Util.encode(input, out, multiLineOutput);
            return new String(out.toByteArray(), StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static String encode(byte[] data) {
        return Base64Util.encode(data, true);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[10000];
        int ln = 0;
        while ((ln = in.read(bytes)) > 0) {
            out.write(bytes, 0, ln);
        }
        out.flush();
    }
}

