/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import com.codahale.metrics.Meter;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.metricstore.FilterOptions;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.rocksdb.RocksDbStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCleaner
implements Runnable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsCleaner.class);
    private static final long DEFAULT_SLEEP_MS = 14400000L;
    private final RocksDbStore store;
    private final long retentionHours;
    private final Meter failureMeter;
    private volatile boolean shutdown = false;
    private long sleepMs = 14400000L;
    private long purgeTimestamp = 0L;

    MetricsCleaner(RocksDbStore store, int retentionHours, int hourlyPeriod, Meter failureMeter, StormMetricsRegistry metricsRegistry) {
        this.store = store;
        this.retentionHours = retentionHours;
        if (hourlyPeriod > 0) {
            this.sleepMs = (long)hourlyPeriod * 60L * 60L * 1000L;
        }
        this.failureMeter = failureMeter;
        metricsRegistry.registerGauge("MetricsCleaner:purgeTimestamp", () -> this.purgeTimestamp);
    }

    @Override
    public void close() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                Thread.sleep(this.sleepMs);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted", (Throwable)e);
                continue;
            }
            try {
                this.purgeMetrics();
            }
            catch (MetricException e) {
                LOG.error("Failed to purge metrics", (Throwable)e);
                if (this.failureMeter == null) continue;
                this.failureMeter.mark();
            }
        }
    }

    void purgeMetrics() throws MetricException {
        this.purgeTimestamp = System.currentTimeMillis() - this.retentionHours * 60L * 60L * 1000L;
        LOG.info("Purging metrics before {}", (Object)this.purgeTimestamp);
        FilterOptions filter = new FilterOptions();
        long endTime = this.purgeTimestamp - 1L;
        filter.setEndTime(endTime);
        this.store.deleteMetrics(filter);
        LOG.info("Purging metadata before " + this.purgeTimestamp);
        this.store.deleteMetadataBefore(this.purgeTimestamp);
    }
}

