/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.metastorage.dsl.ConditionType;
import org.apache.ignite3.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite3.internal.metastorage.dsl.RevisionConditionBuilder;
import org.apache.ignite3.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class RevisionConditionDeserializer
implements MessageDeserializer<SimpleCondition.RevisionCondition> {
    private final RevisionConditionBuilder msg;

    RevisionConditionDeserializer(MetaStorageMessagesFactory messageFactory) {
        this.msg = messageFactory.revisionCondition();
    }

    @Override
    public Class<SimpleCondition.RevisionCondition> klass() {
        return SimpleCondition.RevisionCondition.class;
    }

    @Override
    public SimpleCondition.RevisionCondition getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.key(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("revision");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.revision(tmp);
                reader.incrementState();
            }
            case 2: {
                int shiftedId = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                ConditionType tmp = shiftedId == 0 ? null : ConditionType.fromId(shiftedId - 1);
                this.msg.type(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SimpleCondition.RevisionCondition.class);
    }
}

