/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.cassandra.service;

import java.net.UnknownHostException;

import org.junit.Assert;
import org.junit.Test;

import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;

public class FailureRecordingCallbackTest
{
    @Test
    public void testFailuresCount() throws UnknownHostException
    {
        FailureRecordingCallback cb = new FailureRecordingCallback()
        {

            @Override
            public void onResponse(Message msg) {}
            @Override
            public boolean invokeOnFailure() { return super.invokeOnFailure();}
            @Override
            public boolean trackLatencyForSnitch() { return super.trackLatencyForSnitch();}
        };
        cb.onFailureWithMutex(InetAddressAndPort.getByName("127.0.0.1"), RequestFailureReason.UNKNOWN);
        cb.onFailureWithMutex(InetAddressAndPort.getByName("127.0.0.2"), RequestFailureReason.UNKNOWN);
        cb.onFailureWithMutex(InetAddressAndPort.getByName("127.0.0.3"), RequestFailureReason.TIMEOUT);
        Assert.assertEquals(2, cb.failureReasonsAsMap().failureCount());
    }
}
