/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.flownetwork;

import org.psjava.ds.graph.AllEdgeInGraph;
import org.psjava.ds.graph.CapacityEdge;
import org.psjava.ds.graph.FlowNetworkEdge;
import org.psjava.ds.graph.FlowStatus;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.MutableDirectedGraph;
import org.psjava.ds.graph.SimpleFlowNetworkEdge;
import org.psjava.ds.numbersystrem.AddableNumberSystem;

public class EmptyFlowNetworkGraph {
    public static <V, T, E extends CapacityEdge<V, T>> Graph<V, FlowNetworkEdge<V, T, E>> create(Graph<V, E> capacityGraph, AddableNumberSystem<T> ns) {
        MutableDirectedGraph g = MutableDirectedGraph.create();
        for (Object v : capacityGraph.getVertices()) {
            g.insertVertex(v);
        }
        for (CapacityEdge edge : AllEdgeInGraph.wrap(capacityGraph)) {
            FlowNetworkEdge original = SimpleFlowNetworkEdge.create(edge.from(), edge.to(), new FlowStatus(edge.capacity(), ns.getZero()), edge);
            FlowNetworkEdge skewSymmetry = SimpleFlowNetworkEdge.create(edge.to(), edge.from(), new FlowStatus<T>(ns.getZero(), ns.getZero()), null);
            original.setOpposite(skewSymmetry);
            skewSymmetry.setOpposite(original);
            g.addEdge(original);
            g.addEdge(skewSymmetry);
        }
        return g;
    }

    private EmptyFlowNetworkGraph() {
    }
}

