/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.time.Duration;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.cassandra.schema.DistributedSchema;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.schema.SchemaTransformation;
import org.apache.cassandra.schema.SchemaUpdateHandler;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.concurrent.Awaitable;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineSchemaUpdateHandler
implements SchemaUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(OfflineSchemaUpdateHandler.class);
    private final BiConsumer<SchemaTransformation.SchemaTransformationResult, Boolean> updateCallback;
    private volatile DistributedSchema schema = DistributedSchema.EMPTY;

    public OfflineSchemaUpdateHandler(BiConsumer<SchemaTransformation.SchemaTransformationResult, Boolean> updateCallback) {
        this.updateCallback = updateCallback;
    }

    @Override
    public void start() {
    }

    @Override
    public boolean waitUntilReady(Duration timeout) {
        return true;
    }

    @Override
    public synchronized SchemaTransformation.SchemaTransformationResult apply(SchemaTransformation transformation, boolean local) {
        DistributedSchema before = this.schema;
        Keyspaces afterKeyspaces = transformation.apply(before.getKeyspaces());
        Keyspaces.KeyspacesDiff diff = Keyspaces.diff(before.getKeyspaces(), afterKeyspaces);
        if (diff.isEmpty()) {
            return new SchemaTransformation.SchemaTransformationResult(before, before, diff);
        }
        DistributedSchema after = new DistributedSchema(afterKeyspaces, UUID.nameUUIDFromBytes(ByteArrayUtil.bytes(afterKeyspaces.hashCode())));
        SchemaTransformation.SchemaTransformationResult update = new SchemaTransformation.SchemaTransformationResult(before, after, diff);
        this.schema = after;
        logger.debug("Schema updated: {}", (Object)update);
        this.updateCallback.accept(update, true);
        return update;
    }

    @Override
    public void reset(boolean local) {
        if (!local) {
            throw new UnsupportedOperationException();
        }
        this.apply(ignored -> SchemaKeyspace.fetchNonSystemKeyspaces(), local);
    }

    @Override
    public synchronized Awaitable clear() {
        this.schema = DistributedSchema.EMPTY;
        return ImmediateFuture.success(true);
    }
}

