/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.Objects;
import org.apache.cassandra.config.Converters;
import org.apache.cassandra.config.ForwardingProperty;
import org.yaml.snakeyaml.introspector.Property;

public final class Replacement {
    public final Class<?> parent;
    public final String oldName;
    public final Class<?> oldType;
    public final String newName;
    public final Converters converter;
    public final boolean deprecated;

    public Replacement(Class<?> parent, String oldName, Class<?> oldType, String newName, Converters converter, boolean deprecated) {
        this.parent = Objects.requireNonNull(parent);
        this.oldName = Objects.requireNonNull(oldName);
        this.oldType = Objects.requireNonNull(oldType);
        this.newName = Objects.requireNonNull(newName);
        this.converter = Objects.requireNonNull(converter);
        this.deprecated = deprecated;
    }

    public Property toProperty(final Property newProperty) {
        return new ForwardingProperty(this.oldName, this.oldType, newProperty){

            @Override
            public void set(Object o, Object o1) throws Exception {
                newProperty.set(o, Replacement.this.converter.convert(o1));
            }

            @Override
            public Object get(Object o) {
                return Replacement.this.converter.unconvert(newProperty.get(o));
            }
        };
    }

    public boolean isValueFormatReplacement() {
        return this.oldName.equals(this.newName);
    }
}

