/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth.jmx;

import java.security.AccessController;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationProxy
implements JMXAuthenticator {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationProxy.class);
    private final String loginConfigName;

    public AuthenticationProxy(String loginConfigName) {
        if (loginConfigName == null) {
            throw new ConfigurationException("JAAS login configuration missing for JMX authenticator setup");
        }
        this.loginConfigName = loginConfigName;
    }

    @Override
    public Subject authenticate(Object credentials) {
        JMXCallbackHandler callbackHandler = new JMXCallbackHandler(credentials);
        try {
            LoginContext loginContext = new LoginContext(this.loginConfigName, callbackHandler);
            loginContext.login();
            Subject subject = loginContext.getSubject();
            if (!subject.isReadOnly()) {
                AccessController.doPrivileged(() -> {
                    subject.setReadOnly();
                    return null;
                });
            }
            return subject;
        }
        catch (LoginException e) {
            logger.trace("Authentication exception", (Throwable)e);
            throw new SecurityException("Authentication error", e);
        }
    }

    private static final class JMXCallbackHandler
    implements CallbackHandler {
        private char[] username;
        private char[] password;

        private JMXCallbackHandler(Object credentials) {
            if (credentials instanceof String[]) {
                String[] strings = (String[])credentials;
                if (strings[0] != null) {
                    this.username = strings[0].toCharArray();
                }
                if (strings[1] != null) {
                    this.password = strings[1].toCharArray();
                }
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(this.username == null ? null : new String(this.username));
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(this.password == null ? null : this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback: " + callbacks[i].getClass().getName());
            }
        }
    }
}

