/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public class UniqueMicroTimeProvider
implements TimeProvider {
    public static final UniqueMicroTimeProvider INSTANCE = new UniqueMicroTimeProvider();
    private final AtomicLong lastTime = new AtomicLong();
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    public UniqueMicroTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        this.lastTime.set(provider.currentTimeMicros());
        return this;
    }

    @Override
    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        long time = this.provider.currentTimeMicros();
        while (true) {
            long time0;
            if ((time0 = this.lastTime.get()) >= time) {
                time = time0 + 1L;
            }
            if (this.lastTime.compareAndSet(time0, time)) {
                return time;
            }
            Jvm.nanoPause();
        }
    }

    @Override
    public long currentTimeNanos() {
        long time = this.provider.currentTimeNanos();
        long timeUS = time / 1000L;
        while (true) {
            long time0;
            if ((time0 = this.lastTime.get()) >= time / 1000L) {
                timeUS = time0 + 1L;
                time = timeUS * 1000L;
            }
            if (this.lastTime.compareAndSet(time0, timeUS)) {
                return time;
            }
            Jvm.nanoPause();
        }
    }
}

