% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\docType{methods}
\name{define_array}
\alias{define_array}
\title{Define the properties of a new Zarr array.}
\usage{
define_array(data_type, shape)
}
\arguments{
\item{data_type}{The data type of the Zarr array.}

\item{shape}{An integer vector giving the length along each dimension of the
array.}
}
\value{
A \code{array_builder} instance with which a Zarr array can be created.
}
\description{
With this function you can create a skeleton Zarr array from some  key
properties and a number of derived properties. Compression of the data is set
to a default algorithm and level. This function returns an \link{array_builder}
instance with which you can create directly the Zarr array, or set further
properties before creating the array.
}
\examples{
x <- array(1:120, c(3, 8, 5))
def <- define_array("int32", dim(x))
def$chunk_shape <- c(4, 4, 4)
z <- create_zarr() # Creates a Zarr object in memory
arr <- z$add_array("/", "my_array", def)
arr$write(x)
arr
}
