% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dt_rows.R
\name{get_dt_rows}
\alias{get_dt_rows}
\title{Map \code{lenghtMenu} property}
\usage{
get_dt_rows(dt_name, dt_rows)
}
\arguments{
\item{dt_name}{\code{ns()} of \code{inputId} of the \code{DT::datatable}}

\item{dt_rows}{\code{ns()} of \code{inputId} of the variable that holds the current selected value of \code{lengthMenu}}
}
\value{
(\code{shiny::tagList}) A \verb{shiny tagList}.
}
\description{
Maps the \code{lengthMenu} selected value property of \code{DT::datatable} to a \code{shiny} variable.
}
\examples{
\dontshow{if (requireNamespace("DT", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(shiny)
library(DT)

ui <- function(id) {
  ns <- NS(id)
  tagList(
    get_dt_rows(ns("data_table"), ns("dt_rows")),
    textOutput(ns("rows")),
    DT::DTOutput(ns("data_table"))
  )
}

# use the input$dt_rows in the Shiny Server function
server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$data_table <- DT::renderDataTable(iris)
    # Change rows selected to see the first line on the UI change
    rows <- reactive({
      paste0("Selected Rows ", input$dt_rows)
    })
    output$rows <- renderText(rows())
  })
}
if (interactive()) {
  shinyApp(
    ui = ui("my_table_module"),
    server = function(input, output, session) server("my_table_module")
  )
}
\dontshow{\}) # examplesIf}
}
