% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial_models.R
\name{polynomial_model}
\alias{polynomial_model}
\title{Polynomial models}
\usage{
polynomial_model(data, k, type, link = "log")
}
\arguments{
\item{data}{the input data frame, must either have `age`, `pos`, `tot` columns (for aggregated data) OR `age`, `status` for (linelisting data)}

\item{k}{degree of the model.}

\item{type}{name of method (Muench, Giffith, Grenfell).}

\item{link}{link function.}
}
\value{
a list of class polynomial_model with 5 items
  \item{datatype}{type of datatype used for model fitting (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{info}{fitted "glm" object}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Refers to section 6.1.1
}
\examples{
data <- parvob19_fi_1997_1998[order(parvob19_fi_1997_1998$age), ]
data$status <- data$seropositive
aggregated <- transform_data(data$age, data$seropositive, heterogeneity_col = "age")

# fit with aggregated data
model <- polynomial_model(aggregated, type = "Muench")
# fit with linelisting data
model <- polynomial_model(data, type = "Muench")
plot(model)

}
