% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_PSD}
\alias{calc_PSD}
\title{Power Spectral Density Calculator}
\usage{
calc_PSD(chain, max_freq = 0.1, filter_freq = TRUE, plot = FALSE)
}
\arguments{
\item{chain}{Matrix of n x d dimensions, n = iterations, d = dimensions sequence}

\item{max_freq}{The maximum frequency to be considered in PSD if \code{filter_freq = TRUE}. See also \code{Details}.}

\item{filter_freq}{Boolean. Whether PSD only considers the frequencies between 0 and \code{max_freq}. The default setting is \code{TRUE}. See also \code{Details}.}

\item{plot}{Boolean. Whether to return a plot or the elements used to make it.}
}
\value{
Returns a list with log frequencies, log PSDs, and slope and intercept estimates.
}
\description{
This function estimates the log power spectral density against the log frequency, and calculates a slope \eqn{\alpha}.
}
\details{
A number of studies have reported that cognitive activities contain a long-range slowly decaying autocorrelation. In the frequency domain, this is expressed as \eqn{S(f)} ~  \eqn{1/f^{-\alpha}}, with \eqn{f} being frequency, \eqn{S(f)} being spectral power, and \eqn{\alpha} \eqn{\epsilon} \eqn{[0.5,1.5]} is considered \eqn{1/f} scaling. See See \insertCite{zhu2018MentalSamplingMultimodal;textual}{samplr} for a comparison of Levy Flight and PSD measures for different samplers in multimodal representations.

The default frequency range in PSD analysis extends from 0 to 0.1, which is specified by \code{max_freq}. It is because the logarithmic spectral power density tends to flatten beyond a frequency of 0.1. As a result, some researchers (e.g., \insertCite{gildenNoiseHuman1995;nobrackets}{samplr}; \insertCite{zhu2022UnderstandingStructureCognitive;nobrackets}{samplr}) estimate the value of \eqn{\alpha} using only frequencies below 0.1. When \code{filter_freq} is set to \code{FALSE}, the frequency range will be from 0 to the Nyquist frequency.
}
\examples{
set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
calc_PSD(chain1[[1]], plot= TRUE)
}
\references{
\insertAllCited{}
}
