
<!-- README.md is generated from README.Rmd. Please edit that file -->

# prqlr <img src="man/figures/logo.png" align="right" width="150"/>

<!-- badges: start -->

[![prqlr status
badge](https://prql.r-universe.dev/badges/prqlr)](https://prql.r-universe.dev)
[![CRAN
status](https://www.r-pkg.org/badges/version/prqlr)](https://CRAN.R-project.org/package=prqlr)
[![R-multiverse
status](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fcommunity.r-multiverse.org%2Fapi%2Fpackages%2Fprqlr&query=%24.Version&label=r-multiverse)](https://community.r-multiverse.org/prqlr)
<!-- badges: end -->

R bindings for [the `prqlc` Rust library](https://github.com/prql/prql),
powered by [`savvy`](https://github.com/yutannihilation/savvy).

This version supports PRQL 0.13.4.

## Installation

Requires R 4.2.0 or later.

This latest release version of this package can be installed from CRAN
or [R-multiverse](https://r-multiverse.org). If available, a binary
package will be installed.

``` r
# Install from CRAN
install.packages("prqlr")
```

``` r
# Install from the R-multiverse Community Repository
install.packages("prqlr", repos = "https://community.r-multiverse.org")
```

Development version of this package can be installed from PRQL’s
[R-universe](https://prql.r-universe.dev/prqlr) repository.

``` r
# Install from R-universe
install.packages("prqlr", repos = "https://prql.r-universe.dev")
```

For source installation, pre-built Rust libraries may be available if
the environment variable `NOT_CRAN` is set to `"true"`. (Or, set
`LIBPRQLR_BUILD` to `"false"`)

``` r
Sys.setenv(NOT_CRAN = "true")
install.packages("prqlr")
```

Or, the Rust toolchain (Rust 1.73.0 or later) must be configured to
build the Rust library.

Please check the <https://github.com/r-rust/hellorust> repository for
about Rust code in R packages.

## Examples

``` r
library(prqlr)

"from mtcars | filter cyl > 6 | select {cyl, mpg}" |>
  prql_compile() |>
  cat()
#> SELECT
#>   cyl,
#>   mpg
#> FROM
#>   mtcars
#> WHERE
#>   cyl > 6
#> 
#> -- Generated by PRQL compiler version:0.13.4 (https://prql-lang.org)
```

PRQL’s pipelines can be joined by the newline character (`\n`), or
actual newlines in addition to `|`.

``` r
"from mtcars \n filter cyl > 6 \n select {cyl, mpg}" |>
  prql_compile() |>
  cat()
#> SELECT
#>   cyl,
#>   mpg
#> FROM
#>   mtcars
#> WHERE
#>   cyl > 6
#> 
#> -- Generated by PRQL compiler version:0.13.4 (https://prql-lang.org)
```

``` r
"from mtcars
filter cyl > 6
select {cyl, mpg}" |>
  prql_compile() |>
  cat()
#> SELECT
#>   cyl,
#>   mpg
#> FROM
#>   mtcars
#> WHERE
#>   cyl > 6
#> 
#> -- Generated by PRQL compiler version:0.13.4 (https://prql-lang.org)
```

Thanks to the `{tidyquery}` package, we can even convert a PRQL query to
a SQL query and then to a `{dplyr}` query!

``` r
"from mtcars
filter cyl > 6
select {cyl, mpg}" |>
  prql_compile() |>
  tidyquery::show_dplyr()
#> mtcars %>%
#>   filter(cyl > 6) %>%
#>   select(cyl, mpg)
```

## `{knitr}` integration

Using `{prqlr}` with `{knitr}` makes it easy to create documents that
lists PRQL queries and a translated SQL queries, or documents that lists
PRQL queries and tables of data retrieved by PRQL queries.

Please check the vignette `vignette("knitr", "prqlr")` for details.
