% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcens_quantile.R
\name{pcens_quantile}
\alias{pcens_quantile}
\title{Compute primary event censored quantiles}
\usage{
pcens_quantile(object, p, pwindow, D = Inf, use_numeric = FALSE, ...)
}
\arguments{
\item{object}{A \code{primarycensored} object as created by \code{\link[=new_pcens]{new_pcens()}}.}

\item{p}{A vector of probabilities at which to compute the quantiles.}

\item{pwindow}{Primary event window}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{use_numeric}{Logical; if TRUE forces the use of numeric inversion even
if an analytical solution is available (not yet implemented).}

\item{...}{Additional arguments to be passed to pdist}
}
\value{
Vector of primary event censored quantiles.
}
\description{
This function inverts the primary event censored CDF to compute quantiles.
It uses numerical optimisation via optim to find the value q such that
\code{\link[=pcens_cdf]{pcens_cdf()}} is close to the specified probability. Currently, only the
default numerical inversion method is implemented. Future analytical
solutions may be added.
}
\seealso{
Low level primary event censored distribution objects and methods
\code{\link{new_pcens}()},
\code{\link{pcens_cdf}()},
\code{\link{pcens_cdf.default}()},
\code{\link{pcens_cdf.pcens_pgamma_dunif}()},
\code{\link{pcens_cdf.pcens_plnorm_dunif}()},
\code{\link{pcens_cdf.pcens_pweibull_dunif}()},
\code{\link{pcens_quantile.default}()}
}
\concept{pcens}
