% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_module_loop_comma.R
\name{process_module_loop_comma}
\alias{process_module_loop_comma}
\title{Process Module Components with Comma Handling}
\usage{
process_module_loop_comma(
  KO_vector,
  module_abundance,
  process_step_comma,
  process_step_direct,
  aggregrate_rowname = "step_1",
  step_count = 1,
  comma_scale_method
)
}
\arguments{
\item{KO_vector}{Character vector of KO identifiers to process}

\item{module_abundance}{Data frame containing KO abundance data}

\item{process_step_comma}{Function to handle comma-separated KOs (alternative forms)}

\item{process_step_direct}{Function to handle individual KOs}

\item{aggregrate_rowname}{Base name for row aggregation (default: 'step_1')}

\item{step_count}{Counter for processing steps (default: 1)}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}
}
\value{
List containing:
- abundance_table: Processed abundance Data frame
- step_count: Updated step counter
- abundance_log: log
}
\description{
Processes a vector of KOs, applying different handling methods depending on whether
they contain commas or not. Useful for processing complex pathway definitions with
alternative KOs.
}
