% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.cumhist}
\alias{coef.cumhist}
\title{Extract Model Coefficients}
\usage{
\method{coef}{cumhist}(object, summary = TRUE, probs = c(0.055, 0.945), ...)
}
\arguments{
\item{object}{An object of class \link[=cumhist-class]{cumhist}}

\item{summary}{Whether summary statistics should be returned instead of
raw sample values. Defaults to \code{TRUE}}

\item{probs}{The percentiles used to compute summary, defaults to 89\% credible interval.}

\item{...}{Unused.}
}
\value{
data.frame with values or summary
}
\description{
Extracts models population-level coefficients history-specific terms and
fixed-effect terms for every modeled distribution parameter.
}
\examples{
\donttest{
br_fit <- fit_cumhist(br_singleblock,
                      state = "State",
                      duration = "Duration",
                      fixed_effects = "Time")
coef(br_fit)
}
}
