% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_scatter_residuals}
\alias{plot_scatter_residuals}
\title{Plotting Residuals vs Predictions}
\usage{
plot_scatter_residuals(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_scatter_residuals()} function produces scatter plots relating residuals to predictions, facilitating
identification of heteroscedasticity and non-linear patterns in model errors. This diagnostic plot is essential
for validating regression model assumptions and detecting potential issues with model specification or data quality.
}
\examples{
# Note: For obtaining the residuals vs. predicted values plot the user needs to
# complete till fine_tuning( ) function of the MLwrap pipeline.

\dontrun{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")

# And then, you can obtain the residuals vs predicted values plot.

plot_scatter_residuals(wrap_object)

}

}
