% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR.R
\name{get_batched_embeddings}
\alias{get_batched_embeddings}
\title{Generate Embeddings in Batches}
\usage{
get_batched_embeddings(texts, embed_config, batch_size = 50, verbose = FALSE)
}
\arguments{
\item{texts}{Character vector of texts to embed. If named, the names will be
used as row names in the output matrix.}

\item{embed_config}{An \code{llm_config} object configured for embeddings.}

\item{batch_size}{Integer. Number of texts to process in each batch. Default is 50.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
A numeric matrix where each row is an embedding vector for the corresponding text.
If embedding fails for certain texts, those rows will be filled with NA values.
The matrix will always have the same number of rows as the input texts.
Returns NULL if no embeddings were successfully generated.
}
\description{
A wrapper function that processes a list of texts in batches to generate embeddings,
avoiding rate limits. This function calls \code{\link{call_llm_robust}} for each
batch and stitches the results together and parses them (using \code{parse_embeddings}) to
return a numeric matrix.
}
\examples{
\dontrun{
  # Basic usage
  texts <- c("Hello world", "How are you?", "Machine learning is great")
  names(texts) <- c("greeting", "question", "statement")

  embed_cfg <- llm_config(
    provider = "voyage",
    model = "voyage-large-2-instruct",
    embedding = TRUE,
    api_key = Sys.getenv("VOYAGE_API_KEY")
  )

  embeddings <- get_batched_embeddings(
    texts = texts,
    embed_config = embed_cfg,
    batch_size = 2
  )
}
}
\seealso{
\code{\link{llm_config}} to create the embedding configuration.
\code{\link{parse_embeddings}} to convert the raw response to a numeric matrix.
}
