% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.SSN2}
\alias{augment.SSN2}
\alias{augment.ssn_lm}
\alias{augment.ssn_glm}
\title{Augment data with information from fitted model objects}
\usage{
\method{augment}{ssn_lm}(
  x,
  drop = TRUE,
  newdata = NULL,
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  local,
  ...
)

\method{augment}{ssn_glm}(
  x,
  drop = TRUE,
  newdata = NULL,
  type.predict = c("link", "response"),
  type.residuals = c("deviance", "pearson", "response"),
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  newdata_size,
  level = 0.95,
  local = local,
  var_correct = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{drop}{A logical indicating whether to drop extra variables in the
fitted model object \code{x} when augmenting. The default for \code{drop} is \code{TRUE}.
\code{drop} is ignored if augmenting \code{newdata}.}

\item{newdata}{A vector that contains the names of the prediction \code{sf}
objects from the original \code{ssn.object} requiring prediction.
All of the original explanatory variables used to create the fitted model object \code{x}
must be present in each prediction \code{sf} object represented by \code{newdata}.
Defaults to \code{NULL}, which indicates
that nothing has been passed to \code{newdata} and augmenting occurs
for the original data. The value \code{"ssn"} is shorthand for specifying
all prediction \code{sf} objects.}

\item{se_fit}{Logical indicating whether or not a \code{.se.fit} column should
be added to augmented output. Passed to \code{predict()} and
defaults to \code{FALSE}.}

\item{interval}{Character indicating the type of confidence interval columns to
add to the augmented \code{newdata} output. Passed to \code{predict()} and defaults
to \code{"none"}.}

\item{level}{Tolerance/confidence level. The default is \code{0.95}.}

\item{local}{A list or logical. If a list, specific list elements described
in \code{\link[=predict.ssn_lm]{predict.ssn_lm()}} or \code{\link[=predict.ssn_glm]{predict.ssn_glm()}} control the big data approximation behavior.
If a logical, \code{TRUE} chooses default list elements for the list version
of \code{local} as specified in \code{\link[=predict.ssn_lm]{predict.ssn_lm()}} or \code{\link[=predict.ssn_glm]{predict.ssn_glm()}}. Defaults to \code{FALSE},
which performs exact computations.}

\item{...}{Additional arguments to \code{predict()} when augmenting \code{newdata}.}

\item{type.predict}{The scale (\code{response} or \code{link}) of fitted
values and predictions obtained using \code{ssn_glm()} objects.}

\item{type.residuals}{The residual type (\code{deviance}, \code{pearson}, or \code{response})
of fitted models from \code{ssn_glm()} objects. Ignored if
\code{newdata} is specified.}

\item{newdata_size}{The \code{size} value for each observation in \code{newdata}
used when predicting for the binomial family.}

\item{var_correct}{A logical indicating whether to return the corrected prediction
variances when predicting via models fit using \code{ssn_glm}. The default is
\code{TRUE}.}
}
\value{
When augmenting the original data set, a tibble with additional columns
\itemize{
\item \code{.fitted}: Fitted value
\item \code{.resid}: Response residual (the difference between observed and fitted values)
\item \code{.hat}: Leverage (diagonal of the hat matrix)
\item \code{.cooksd}: Cook's distance
\item \code{.std.resid}: Standardized residuals
\item \code{.se.fit}: Standard error of the fitted value.
}

When augmenting a new data set, a tibble with additional columns
\itemize{
\item \code{.fitted}: Predicted (or fitted) value
\item \code{.lower}: Lower bound on interval
\item \code{.upper}: Upper bound on interval
\item \code{.se.fit}: Standard error of the predicted (or fitted) value
}

When predictions for all prediction objects are desired, the output is a list
where each element has a name that matches the prediction objects and values
that are the predictions.
}
\description{
Augment accepts a fitted model object and a data set and adds
information about each observation in the data set. New columns always
begin with a \code{.} prefix to avoid overwriting columns in the original
data set.

Augment behaves differently depending on whether the original data or new data
requires augmenting. Typically, when augmenting the original data, only the fitted
model object is specified, and when augmenting new data, the fitted model object
and \code{newdata} are specified. When augmenting the original data, diagnostic
statistics are augmented to each row in the data set. When augmenting new data,
predictions and optional intervals (confidence or prediction) or standard errors are augmented to each
row in the new data set.
}
\details{
\code{augment()} returns a tibble as an \code{sf} object.

Missing response values from the original data can be augmented as if
they were a \code{newdata} object by providing \code{".missing"} to the
\code{newdata} argument.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, predpts = "CapeHorn", overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
augment(ssn_mod)
augment(ssn_mod, newdata = "CapeHorn")
}
\seealso{
\code{\link[=tidy.SSN2]{tidy.SSN2()}} \code{\link[=glance.SSN2]{glance.SSN2()}}
}
