% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betabinom.R
\name{betabinom}
\alias{betabinom}
\alias{dbetabinom}
\alias{rbetabinom}
\title{Beta-binomial distribution}
\usage{
dbetabinom(x, size, shape1, shape2, log = FALSE)

rbetabinom(n, size, shape1, shape2)
}
\arguments{
\item{x}{vector of non-negative counts.}

\item{size}{vector of total counts (number of trials). Needs to be >= \code{x}.}

\item{shape1}{positive shape parameter 1 of the Beta prior.}

\item{shape2}{positive shape parameter 2 of the Beta prior.}

\item{log}{logical; if \code{TRUE}, densities are returned on the log scale.}

\item{n}{number of random values to return (for \code{rbetabinom}).}
}
\value{
\code{dbetabinom} gives the density and \code{rbetabinom} generates random samples.
}
\description{
Density and random generation for the beta-binomial distribution.
}
\details{
This implementation of \code{dbetabinom} allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rbetabinom(1, 10, 2, 5)
d <- dbetabinom(x, 10, 2, 5)
}
