% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{portfolio_returns}
\alias{portfolio_returns}
\title{Portfolio returns from weights and prices (CASH-aware)}
\usage{
portfolio_returns(weights, prices, cost_bps = 0)
}
\arguments{
\item{weights}{A data.frame/data.table of portfolio weights on rebalance dates:
first column \code{Date}, remaining columns one per symbol (numeric weights).
Weights decided at \eqn{t-1} are applied to returns over \eqn{t}.}

\item{prices}{A data.frame/data.table of adjusted prices at the same cadence:
first column \code{Date}, remaining columns one per symbol.}

\item{cost_bps}{One-way proportional cost per side in basis points (e.g., \code{10}
for 10 bps). Default \code{0}. If \verb{> 0} and your package exposes a turnover
helper, it will be used; otherwise costs are ignored with a warning.}
}
\value{
A \code{data.table} with columns \code{Date} and \code{ret} (portfolio simple return).
}
\description{
Computes the portfolio simple return series by applying (lagged) portfolio
weights to next-period asset returns, optionally net of proportional costs.
}
\details{
\strong{CASH support:} if \code{weights} contains a column named \code{"CASH"} (case-insensitive)
but \code{prices} has no matching column, a synthetic flat price series is added
internally (price = 1 \eqn{\Rightarrow}{=>} return = 0). In that case the function does \strong{not}
re-normalise the non-CASH weights; the row is treated as a complete budget
(symbols + CASH = 1).

The function carries forward the latest available weights to each return row
via the usual one-period decision lag. Transaction cost handling is conservative:
if a turnover helper is not available, costs are skipped.
}
\examples{
\donttest{
  data(sample_prices_weekly)
  mom12 <- PortfolioTesteR::calc_momentum(sample_prices_weekly, 12)
  sel10 <- PortfolioTesteR::filter_top_n(mom12, 10)
  w_eq  <- PortfolioTesteR::weight_equally(sel10)

  pr <- portfolio_returns(w_eq, sample_prices_weekly, cost_bps = 0)
  head(pr)
}

}
\seealso{
PortfolioTesteR::panel_returns_simple
}
