% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{ml_backtest}
\alias{ml_backtest}
\title{One-call backtest wrapper (tabular features)}
\usage{
ml_backtest(
  features_list,
  labels,
  fit_fn,
  predict_fn,
  schedule = list(is = 156L, oos = 4L, step = 4L),
  group = c("pooled", "per_symbol", "per_group"),
  transform = c("none", "zscore", "rank"),
  selection = list(top_k = 15L, max_per_group = NULL),
  group_map = NULL,
  weighting = list(method = "softmax", temperature = 12, floor = 0),
  caps = list(max_per_symbol = 0.1, max_per_group = NULL),
  turnover = NULL,
  prices,
  initial_capital = 1e+05,
  name = "ML backtest"
)
}
\arguments{
\item{features_list}{list of wide panels (each: \code{Date} + symbols).}

\item{labels}{Wide label panel (Date + symbols).}

\item{fit_fn}{function \verb{(X, y) -> model} trained on in-sample stacked rows.}

\item{predict_fn}{function \verb{(model, Xnew) -> numeric} scores.}

\item{schedule}{list with elements \code{is}, \code{oos}, \code{step}.}

\item{group}{one of \code{"pooled"}, \code{"per_symbol"}, \code{"per_group"}.}

\item{transform}{\code{"none"}, \code{"zscore"}, \code{"rank"} for per-date score transform.}

\item{selection}{list: \code{top_k}, \code{max_per_group} (optional).}

\item{group_map}{optional \code{data.frame(Symbol, Group)} if \code{group = "per_group"}.}

\item{weighting}{list: \code{method}, \code{temperature}, \code{floor}.}

\item{caps}{list: \code{max_per_symbol}, optionally \code{max_per_group}.}

\item{turnover}{Optional turnover cap settings (currently advisory/unused).}

\item{prices}{price panel used by the backtester (\code{Date} + symbols).}

\item{initial_capital}{starting capital.}

\item{name}{string for the backtest result.}
}
\value{
list: \code{scores}, \code{mask}, \code{weights}, \code{backtest}.
}
\description{
One-call backtest wrapper (tabular features)
}
\examples{
\donttest{
data(sample_prices_weekly); data(sample_prices_daily)
mom <- panel_lag(calc_momentum(sample_prices_weekly, 12), 1)
vol <- panel_lag(align_to_timeframe(
  calc_rolling_volatility(sample_prices_daily, 20),
  sample_prices_weekly$Date, "forward_fill"), 1)
Y <- make_labels(sample_prices_weekly, 4, "log")
fit_lm  <- function(X,y){ Xc <- cbind(1,X); list(coef=stats::lm.fit(Xc,y)$coefficients) }
pred_lm <- function(m,X){ as.numeric(cbind(1,X) \%*\% m$coef) }
res <- ml_backtest(list(mom=mom, vol=vol), Y, fit_lm, pred_lm,
                   schedule = list(is=52,oos=4,step=4),
                   transform = "zscore",
                   selection = list(top_k=10),
                   weighting = list(method="softmax", temperature=12),
                   caps = list(max_per_symbol=0.10),
                   prices = sample_prices_weekly, initial_capital = 1e5)
res$backtest
}
}
