% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_cci}
\alias{calc_cci}
\title{Calculate Commodity Channel Index (CCI)}
\usage{
calc_cci(data, period = 20)
}
\arguments{
\item{data}{Data frame with Date column and price columns}

\item{period}{CCI period (default: 20)}
}
\value{
Data.table with CCI values
}
\description{
Calculates CCI using closing prices. CCI measures deviation from average price.
Values above 100 indicate overbought, below -100 indicate oversold.
}
\examples{
data("sample_prices_weekly")
cci <- calc_cci(sample_prices_weekly, period = 20)
}
