% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_vis_sample.R
\name{heatmap_sample}
\alias{heatmap_sample}
\title{Generate Heatmap of Ligand-Receptor Interaction Scores}
\usage{
heatmap_sample(
  lr_scores,
  metadata,
  score = c("normalized", "raw"),
  selected_sender = NULL,
  selected_receiver = NULL,
  selected_metadata = NULL,
  treeheight_row = 50,
  treeheight_col = 50,
  show_LR = FALSE,
  show_sample = FALSE,
  basic_title = NULL
)
}
\arguments{
\item{lr_scores}{Data frame containing LR interaction scores per sample (data frame).}

\item{metadata}{Data frame containing sample metadata (data frame).}

\item{score}{Character string indicating which score to use: "normalized" (default) or "raw" .}

\item{selected_sender}{Specific sender cell type to filter, default is None (use all) (character).}

\item{selected_receiver}{Specific receiver cell type to filter, default is None (use all) (character).}

\item{selected_metadata}{List of column names in \code{metadata} to annotate samples (default: None, use all)(character vector).}

\item{treeheight_row}{The height of a tree for rows (numeric, default: 50).}

\item{treeheight_col}{The height of a tree for columns (numeric, default: 50).}

\item{show_LR}{Whether to display ligand-receptor names on rows (logical, default: FALSE).}

\item{show_sample}{Whether to display sample names on columns (logical, default: FALSE).}

\item{basic_title}{Custom heatmap title (optional).}
}
\value{
A pheatmap object.
}
\description{
This function generates a heatmap to visualize the ligand-receptor (LR) interaction scores across samples.
Rows represent LR pairs and columns represent samples. Optionally, sample metadata can be used to annotate the columns.
}
\examples{
# Heatmap of LR Interaction Scores
data(lr_scores_eg)
data(metadata_eg)

p <- heatmap_sample(
  lr_scores = lr_scores_eg,
  metadata = metadata_eg,
  score = "normalized",
  selected_sender = "Endothelial",
  selected_receiver = "Perivascular",
  selected_metadata = c("Sex", "Age_group", "IFN_type")
  )

print(p)
}
