% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecm_mars.R
\name{ecm_mars}
\alias{ecm_mars}
\title{Error Correction Model with Multivariate Adaptive Regression Splines}
\usage{
ecm_mars(
  data_path,
  circ_vars,
  prod_vars,
  cointeg_rule = "either",
  eg_p_cutoff = 0.05,
  ecm_p_cutoff = 0.05,
  lag_max_ecm = 4,
  min_tr = 20,
  min_te = 8,
  rolling_cv_enable = TRUE,
  rolling_cv_window = "sliding",
  rolling_cv_initial_frac = 0.8,
  rolling_cv_initial_min = 40,
  rolling_cv_test = 12,
  rolling_cv_step = 12,
  nested_tune = TRUE,
  nested_initial_f = 0.6,
  nested_test = 6,
  nested_step = 3,
  mars_grid = expand.grid(degree = c(1, 2), nk = c(15, 25, 35, 50, 65)),
  support_min = 0.75,
  folds_min_abs = 5,
  parallel_enable = TRUE,
  parallel_workers = max(1, parallel::detectCores() - 1)
)
}
\arguments{
\item{data_path}{Path to Excel file containing the data}

\item{circ_vars}{Character vector of circulation variable names}

\item{prod_vars}{Character vector of production variable names}

\item{cointeg_rule}{Cointegration rule ("either" for EG or Johansen, "both" for both)}

\item{eg_p_cutoff}{Significance level for EG/Phillips-Ouliaris test (default: 0.05)}

\item{ecm_p_cutoff}{Significance level for lambda<0 test in linear ECM (default: 0.05)}

\item{lag_max_ecm}{Maximum lags in DeltaY and DeltaX for linear ECM (default: 4)}

\item{min_tr}{Minimum training rows for MARS (default: 20)}

\item{min_te}{Minimum test rows (default: 8)}

\item{rolling_cv_enable}{Whether to enable rolling CV (default: TRUE)}

\item{rolling_cv_window}{Type of window for rolling CV ("sliding" or "expanding", default: "sliding")}

\item{rolling_cv_initial_frac}{Initial fraction for rolling CV (default: 0.8)}

\item{rolling_cv_initial_min}{Minimum initial observations (default: 40)}

\item{rolling_cv_test}{Test horizon for rolling CV (default: 12)}

\item{rolling_cv_step}{Step size for rolling CV (default: 12)}

\item{nested_tune}{Whether to enable nested tuning (default: TRUE)}

\item{nested_initial_f}{Initial fraction for nested tuning (default: 0.6)}

\item{nested_test}{Test horizon for nested tuning (default: 6)}

\item{nested_step}{Step size for nested tuning (default: 3)}

\item{mars_grid}{Data frame with MARS tuning parameters}

\item{support_min}{Minimum proportion of valid folds (default: 0.75)}

\item{folds_min_abs}{Minimum absolute number of valid folds (default: 5)}

\item{parallel_enable}{Whether to enable parallel processing (default: TRUE)}

\item{parallel_workers}{Number of parallel workers (default: detectCores() - 1)}
}
\value{
A data frame with evaluation results for all pairs
}
\description{
Implements a robust ECM benchmark with MARS enhancement for analyzing cointegration
relationships between economic variables with temporal stability validation.
}
\details{
This function implements an Error Correction Model enhanced with Multivariate Adaptive
Regression Splines for analyzing cointegration relationships between economic variables.
It includes comprehensive temporal validation through rolling-origin cross-validation
and nested tuning for MARS parameters. The methodology is described in detail in the
methodological document "DETALLES METODOLOGICOS DE ECM-MARS2.docx".
}
\examples{
\dontrun{
# Example usage
result <- ecm_mars(
  data_path = file.path(tempdir(), "data.xlsx"),
  circ_vars = c("ER.SPOT.CAN.US", "ER.SPOT.US.CAN", "ER.SPOT.US.REMB",
                "CPI", "TreasuryBonds10y", "FedDiscountRate"),
  prod_vars = c("Exports", "RealNetProfit", "RealSocialConsumptionPerWorker2017",
                "RealWagePPP2017", "CapitalStockPPP2017",
                "LaborProductivityPPP2017", "InvestmentPerWorkerPPP2017")
)
}

}
