% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CaMeA.R
\name{camea}
\alias{camea}
\title{Causal Meta Analysis for Aggregated Data}
\usage{
camea(
  measure,
  ai,
  bi,
  ci,
  di,
  n1i,
  n2i,
  slab,
  data = NULL,
  weights = NULL,
  plot = FALSE,
  log.scale = FALSE,
  random.effects = TRUE
)
}
\arguments{
\item{measure}{a character string to specify which effect size or outcome measure should be calculated}

\item{ai}{vector with the 2x2 table frequencies (upper left cell)}

\item{bi}{vector with the 2x2 table frequencies (upper right cell)}

\item{ci}{vector with the 2x2 table frequencies (lower left cell)}

\item{di}{vector with the 2x2 table frequencies (lower right cell)}

\item{n1i}{vector with the group sizes or row totals (first group/row)}

\item{n2i}{vector with the group sizes or row totals (second group/row)}

\item{slab}{optional vector with labels for the studies}

\item{data}{optional data of type data frame, matrix, or dgCMatrix. If NULL, vectors must be provided directly}

\item{weights}{optional vector of study weights, a value of NULL (the default) corresponds to study size / total size}

\item{plot}{set to TRUE to print forestplot, default is FALSE}

\item{log.scale}{set to TRUE to have log scale of the measure (only for RR, OR and SR), default is FALSE}

\item{random.effects}{set to TRUE to have random effects meta-analysis estimate (along with causal meta-analysis estimate) both in the output and in the plot, default is TRUE (possible with all measures except SR)}
}
\value{
A list with the following elements:
\describe{
\item{study_results}{list of effect sizes or outcome measures for each study and associated standard errors}
\item{final_result}{aggregated effect size or outcome measure and associated standard error}
\item{random_effects_model}{random-effect model estimate and standard error, if "random.effects = TRUE"}
}
}
\description{
Function to perform causal meta-analysis on aggregated data of trials with binary treatment and binary outcome.
}
\details{
The function can be used by either inputting "ai,bi,ci,di" or "ai,ci,n1i,n2i". Accepted measures are: "RD" = Risk Difference, "RR" = Risk Ratio, "OR" = Odds Ratio, "SR" = Survival Ratio
}
\examples{
## Example 1: With data frame
data <- data.frame(
  study = paste("Study", 1:5),
  treated_events = c(10, 15, 8, 12, 20),
  treated_total = c(100, 120, 80, 110, 150),
  control_events = c(15, 20, 12, 18, 25),
  control_total = c(100, 115, 85, 105, 145)
)

# Risk difference
result <- camea(measure = "RD", ai = treated_events, n1i = treated_total,
                    ci = control_events, n2i = control_total,
                    data = data, slab = study)

## Example 2: With vectors
treated_positives <- c(13, 5, 14, 18, 9)
treated_negatives <- c(80, 63, 72, 130, 100)
control_positives <- c(25, 18, 34, 23, 16)
control_negatives <- c(125, 98, 165, 117, 85)


# Risk ratio
result <- camea(measure = "RR", ai = treated_positives, bi = treated_negatives,
                    ci = control_positives, di = control_negatives)

}
\references{
Berenfeld, C., Boughdiri, A., Colnet, B., van Amsterdam, W. A. C., Bellet, A.,
Khellaf, R., Scornet, E., & Josse, J. (2025). Causal Meta-Analysis: Rethinking
the Foundations of Evidence-Based Medicine. arXiv:2505.20168.
\url{https://arxiv.org/abs/2505.20168}
}
\author{
Clement Berenfeld, Ahmed Boughdiri, Julie Josse, Charif El Gataa.

\strong{Maintainer}: Clement Berenfeld <clement.berenfeld@inria.fr>
}
