% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.variability.R
\name{plot.variability}
\alias{plot.variability}
\title{Plots a variability diagram from a 'variability' object}
\usage{
\method{plot}{variability}(
  x,
  title = "Variability diagram",
  ylim = NULL,
  ylab = NULL,
  size.lim = NULL,
  max.circle = 25,
  n.circle = 4,
  leg.brk = NULL,
  leg.pos = "right",
  leg.just = "left",
  leg.nrow = NULL,
  leg.title = NULL,
  leg.title.pos = "top",
  ...
)
}
\arguments{
\item{x}{an aobject of class \code{variability}.}

\item{title}{character, plot title.}

\item{ylim}{numeric vector of length two, y-axis limits.}

\item{ylab}{character, y-axis label.}

\item{size.lim}{numeric vector of length two, set limits of the bubbles' size scale (see \code{limits} of \code{\link[ggplot2]{scale_size}}).}

\item{max.circle}{numeric, maximum size of the \code{size} plotting symbol (see \code{range} of \code{\link[ggplot2]{scale_size}}).}

\item{n.circle}{integer; if \code{leg.brk=NULL}, set a sequence of about \code{n.circle+1} equally spaced 'round' values which cover the range of the values used to set the bubbles' size.}

\item{leg.brk}{numeric vector, breaks for bubbles' size legend (see \code{breaks} of \code{\link[ggplot2]{scale_size}}).}

\item{leg.pos}{character or numeric vector of length two, legend position; available options \code{"none"}, \code{"left"}, \code{"right"} (default), \code{"bottom"}, \code{"top"}, or a \code{c(x,y)} numeric vector (\code{x} and \code{y} are coordinates of the legend box; their values should be between 0 and 1; \code{c(0,0)} corresponds to the bottom-left and \code{c(1,1)} corresponds to the top-right position).}

\item{leg.just}{character or numeric vector of length two; anchor point for positioning legend inside plot (\code{"left"} (default), \code{"center"}, \code{"right"} or two-element numeric vector) or the justification according to the plot area when positioned outside the plot.}

\item{leg.nrow}{integer, number of rows of the bubbles' size legend.}

\item{leg.title}{character, title of the bubbles' size legend.}

\item{leg.title.pos}{character, position of the legend title; available options: \code{"top"} (default for a vertical legend), \code{"bottom"}, \code{"left"} (default for a horizontal legend), or \code{"right"}.}

\item{...}{other graphical parameters.}
}
\value{
A \code{ggplot2} object
}
\description{
Plots a variability diagram from a 'variability' object
}
\examples{
Pbox.BC <- subset(Pbox, Team=="Oklahoma City Thunder" & MIN >= 500,
                    select=c("P2p","P3p","FTp","P2A","P3A","FTA"))
out <- variability(data=Pbox.BC, data.var=c("P2p","P3p","FTp"),
                   size.var=c("P2A","P3A","FTA"), weight=TRUE)
plot(out, leg.brk=c(10,25,50,100,500,1000), max.circle=30)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{variability}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
