% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{plot.ycevo}
\alias{plot.ycevo}
\title{Plot the estimated discount functions and yield curves}
\usage{
\method{plot}{ycevo}(
  x,
  est = c("both", "discount", "yield"),
  against = c("tau", "x"),
  loess = TRUE,
  ...
)
}
\arguments{
\item{x}{A \link{ycevo} object}

\item{est}{String. Indicates which estimated values to plot: discount function, yield curve, or
both. Default is both.}

\item{against}{String. Indicates which variable to plot against, i.e. what is on the x axis.
Time-to-maturity \code{tau} or quotation date \code{x}.}

\item{loess}{Logical. If TRUE, the returned discount functions and yield curves
are loess smoothed.}

\item{...}{Additional arguments required for generic consistency. Currently
not used. Warning: A misspelled argument will not raise an error. The
misspelled argument will be either disregarded, or the default value will
be applied if one exists.}
}
\value{
\code{NULL}. The functions produces a plot.
}
\description{
Plots the estimated discount functions and yield curves from a \code{\link[=ycevo]{ycevo()}} object.
}
\examples{
# Simulating bond data
bonds <- ycevo_data(n = 10)
\donttest{
# Estimation can take up to 30 seconds
res <- ycevo(bonds, x = lubridate::ymd("2023-03-01"))
# Plot
plot(res)
}

}
\seealso{
\code{\link[=ycevo]{ycevo()}}, \code{\link[=autoplot.ycevo]{autoplot.ycevo()}}
}
