% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xset_plots.R
\name{prm_waterfall}
\alias{prm_waterfall}
\alias{eta_waterfall}
\alias{iofv_waterfall}
\title{Specific waterfall plots}
\usage{
prm_waterfall(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "bh",
  max_nind = 0.7,
  scale_diff = TRUE,
  show_n = TRUE,
  title = "Parameter changes between models | @run",
  subtitle = "Based on @nobs observations in @nind individuals",
  caption = "@dir",
  tag = NULL,
  facets = NULL,
  facet_scales = "free_x",
  .problem,
  .subprob,
  .method,
  quiet
)

eta_waterfall(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "bh",
  max_nind = 0.7,
  scale_diff = TRUE,
  show_n = TRUE,
  title = "Eta changes between models | @run",
  subtitle = "Based on @nobs observations in @nind individuals",
  caption = "@dir",
  tag = NULL,
  facets = NULL,
  facet_scales = "free_x",
  .problem,
  .subprob,
  .method,
  quiet
)

iofv_waterfall(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "bh",
  max_nind = 0.7,
  scale_diff = FALSE,
  show_n = TRUE,
  title = "iOfv changes between models | @run",
  subtitle = "Based on @nobs observations in @nind individuals",
  caption = "@dir",
  tag = NULL,
  facets = NULL,
  facet_scales = "free_x",
  .problem,
  .subprob,
  .method,
  quiet
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{See <\code{\link{two_set_dots}}>}

\item{.inorder}{See <\code{\link{two_set_dots}}>}

\item{type}{See Details.}

\item{max_nind}{If less than 1, the percentile of absolute
change values above which to plot.
If above 1, the absolute number of subjects is included. To show all,
use an extreme positive number like 9999.}

\item{scale_diff}{<\code{logical}> Scale change to the standard deviation
of the model 1 column values. Respects faceting.}

\item{show_n}{<\code{logical}> For faceting variables, show N per facet.
\emph{Not implemented}}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{facets}{<\code{character}> Faceting variables}

\item{facet_scales}{<\code{character}> Forwarded to \code{facet_*(scales = facet_scales)}}

\item{.problem}{The problem to be used, by default returns the last one.}

\item{.subprob}{The subproblem to be used, by default returns the last one.}

\item{.method}{The estimation method to be used, by default returns the last one.}

\item{quiet}{Silence extra debugging output}
}
\value{
<\code{xpose_plot}> object
}
\description{
Differences are second listed model minus first listed. Eg, in
\code{eta_waterfall(run1,run2)}, the when etas in run2 are greater than
those in run1, the difference will be positive.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{b} bar plot (from \code{geom_bar})
\item \code{h} hline at 0 (from \code{geom_hline})
\item \code{t} text of change value (from \code{geom_text})
}
}
\examples{

# Parameter value changes
pheno_set \%>\%
  # Ensure param is set
  focus_qapply(set_var_types, param=c(CL,V)) \%>\%
  prm_waterfall(run5,run6)


# EBE value changes
pheno_set \%>\%
  eta_waterfall(run5,run6)

# iOFV changes
pheno_set \%>\%
  focus_qapply(backfill_iofv) \%>\%
  # Note the default scaling is flipped here
  iofv_waterfall(run5,run6)


}
