% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpCrossover.R
\name{xegaGpFilterCross2Gene}
\alias{xegaGpFilterCross2Gene}
\title{Crossover of 2 derivation tree genes with node filter.}
\usage{
xegaGpFilterCross2Gene(ng1, ng2, lF)
}
\arguments{
\item{ng1}{Derivation tree.}

\item{ng2}{Derivation tree.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
List of 2 derivation trees.
}
\description{
\code{xegaGpFilterCross2Gene()} swaps two randomly extracted 
             subtrees between 2 genes. Subtrees must have the same
             root in order to be compatible. The current implementation 
             performs at most \code{lF$MaxTrials()} trials to find compatible
             subtrees. If this fails, the original genes are returned.
             Only nodes with a depth
             between \code{lF$MinMutInsertionDepth()} and
             \code{lF$MaxMutInsertionDepth()} are considered as
             candidate roots of derivation trees to be swapped 
             by crossover.
}
\details{
Crossover is controlled by three local parameters:
  \itemize{
     \item \code{lF$MinCrossDepth()} and 
      \code{lF$MaxCrossDepth()} control the possible exchange points 
          for subtrees. The depth of the exchange node must be 
                 between \code{lF$MinMutInsertionDepth()} and
                 \code{lF$MaxMutInsertionDepth()}.
     \item \code{lF$MaxTrials()}: Maximal number of trials to find 
               compatible subtrees. If compatible subtrees are not 
               found, the gene is returned unchanged.
         }
}
\examples{
gene1<-xegaGpInitGene(lFxegaGpGene)
gene2<-xegaGpInitGene(lFxegaGpGene)
xegaGpDecodeGene(gene1, lFxegaGpGene)
xegaGpDecodeGene(gene2, lFxegaGpGene)
newgenes<-xegaGpFilterCross2Gene(gene1, gene2,  lFxegaGpGene)
xegaGpDecodeGene(newgenes[[1]], lFxegaGpGene)
xegaGpDecodeGene(newgenes[[2]], lFxegaGpGene)

}
\seealso{
Other Crossover: 
\code{\link{xegaGpAllCross2Gene}()},
\code{\link{xegaGpAllCrossGene}()},
\code{\link{xegaGpFilterCrossGene}()}
}
\concept{Crossover}
