% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaCrossover.R
\name{xegaGaCrossoverFactory}
\alias{xegaGaCrossoverFactory}
\title{Configure the crossover function of a genetic algorithm.}
\usage{
xegaGaCrossoverFactory(method = "Cross2Gene")
}
\arguments{
\item{method}{A string specifying the crossover function.}
}
\value{
A crossover function for genes.
}
\description{
\code{xegaGaCrossoverFactory()} implements the selection
             of one of the crossover functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item Crossover functions with two kids:
             \enumerate{
             \item "Cross2Gene" returns \code{xegaGaCross2Gene()}.
             \item "UCross2Gene" returns \code{xegaGaUCross2Gene()}.
             \item "UPCross2Gene" returns \code{xegaGaUPCross2Gene()}.
             }
             \item Crossover functions with one kid:
             \enumerate{
             \item "CrossGene" returns \code{xegaGaCrossGene()}.
             \item "UCrossGene" returns \code{xegaGaUCrossGene()}.
             \item "UPCrossGene" returns \code{xegaGaUPCrossGene()}.
             }
             }
}
\details{
Crossover operations which return 2 kids preserve the genetic
         material in the population. However, because we work with fixed 
         size populations, genes with 2 offsprings fill two slots in the
         new population with their genetic material.
}
\examples{
XGene<-xegaGaCrossoverFactory("Cross2Gene")
gene1<-xegaGaInitGene(lFxegaGaGene)
gene2<-xegaGaInitGene(lFxegaGaGene)
XGene(gene1, gene2, lFxegaGaGene)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaGaGene}},
\code{\link{xegaGaGeneMapFactory}()},
\code{\link{xegaGaMutationFactory}()},
\code{\link{xegaGaReplicationFactory}()}
}
\concept{Configuration}
