% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelines.R
\name{newCrossMutPipeline}
\alias{newCrossMutPipeline}
\title{Converts a gene into a genetic operator pipeline with crossover and mutation (a function closure).}
\usage{
newCrossMutPipeline(g, g1, lF)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}

\item{lF}{The local function configuration.}
}
\value{
Closure of genetic operator pipeline 
        with mutation and crossover.
        The argument of the closure \code{lF} 
        configures the behavior of the pipeline.
}
\description{
The pipeline is \code{evaluate(accept((crossover o mutation), gene, gene1))}.
             The symbol \code{o} is short for \code{mutation(crossover(gene, gene1))}
             in the accept function.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {gene}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCrossMutPipeline(g, g1, lFxegaGaGene)
print(a)
a(lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines: 
\code{\link{newCross2Mut1Pipeline}()},
\code{\link{newCross2Mut2Pipeline}()},
\code{\link{newCross2Pipeline}()},
\code{\link{newCrossMut2Pipeline}()},
\code{\link{newCrossPipeline}()},
\code{\link{newMutPipeline}()},
\code{\link{newPipeline}()}
}
\concept{Genetic Operator Pipelines}
