% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{calc_multinom_probs}
\alias{calc_multinom_probs}
\title{Calculate multinomial probabilities}
\usage{
calc_multinom_probs(sar, logt, logc, d, n, nt)
}
\arguments{
\item{sar}{The unrolled matrix containing the portion of the sample space to sum over}

\item{logt}{The vector of candidate theta values, as sampled from the null space}

\item{logc}{The vector of log multinomial coefficients see \link{log_multinom_coef}}

\item{d}{The total dimension, sum(d_j)}

\item{n}{The sample size}

\item{nt}{The number of candidate theta values}
}
\value{
A vector of probabilities
}
\description{
Calculate multinomial probabilities
}
\examples{
sspace_3_5 <- sspace_multinom(3, 5)
calc_multinom_probs(sspace_3_5, sample_unit_simplexn(3, 10),
  apply(matrix(sspace_3_5, ncol = 3, byrow = TRUE), 1, log_multinom_coef, sumx = 5), 3, 5, 10)

}
