% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basefunctions.R
\name{roundR}
\alias{roundR}
\title{Automatic rounding to a reasonable length, based on largest number}
\usage{
roundR(
  roundin,
  level = 2,
  smooth = FALSE,
  textout = TRUE,
  drop0 = FALSE,
  .german = FALSE,
  .bigmark = FALSE
)
}
\arguments{
\item{roundin}{A vector or matrix of numbers.}

\item{level}{A number specifying number of relevant digits to keep.}

\item{smooth}{A logical specifying if you want rounding before the dot
(e.g. 12345 to 12300).}

\item{textout}{A logical if output is converted to text.}

\item{drop0}{A logical if trailing zeros should be dropped.}

\item{.german}{A logical if german numbers should be reported.}

\item{.bigmark}{A logical if big.mark is to be shown, mark itself
depends on parameter .german.}
}
\value{
vector of type character (default) or numeric,
depending on parameter textout.
}
\description{
\code{roundR} takes a vector or matrix of numbers and returns rounded values
with selected precision and various formatting options.
}
\examples{
roundR(1.23456, level = 3)
roundR(1.23456, level = 3, .german = TRUE)
roundR(1234.56, level = 2, smooth = TRUE)
}
