% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basefunctions.R
\name{ColSeeker}
\alias{ColSeeker}
\title{Find numeric index and names of columns based on class(es) and patterns}
\usage{
ColSeeker(
  data = rawdata,
  namepattern = ".",
  varclass = NULL,
  exclude = NULL,
  excludeclass = NULL,
  casesensitive = TRUE,
  returnclass = FALSE
)
}
\arguments{
\item{data}{tibble or data.frame, where columns are to be found; by default rawdata}

\item{namepattern}{Vector of pattern to look for.}

\item{varclass}{Vector, only columns of defined class(es) are returned}

\item{exclude}{Vector of pattern to exclude from found names.}

\item{excludeclass}{Vector, exclude columns of specified class(es)}

\item{casesensitive}{Logical if case is respected in matching (default FALSE: a<>A)}

\item{returnclass}{Logical if classes should be included in output}
}
\value{
A list with index, names, backticked names, and count;  optionally the classes as well
}
\description{
\code{ColSeeker} looks up colnames (by default for tibble rawdata)
based on type and parts of names, using regular expressions.
Be warned that special characters as e.g. \code{[} \code{(} need to be escaped or replaced by \code{.}
Exclusion rules may be specified as well.
}
\examples{
ColSeeker(data = mtcars, namepattern = c("^c", "g"))
ColSeeker(data = mtcars, namepattern = c("^c", "g"), exclude = "r")
assign("rawdata", mtcars)
ColSeeker(namepattern = c("^c", "g"), varclass = "numeric")
num_int_data <- data.frame(num1 = rnorm(10), num2 = runif(10), int1 = 1:10, int2 = 11:20)
ColSeeker(num_int_data, varclass = "numeric") # integers are not found
ColSeeker(num_int_data, varclass = c("numeric", "integer"))
}
