% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBy2Groups.R
\name{plotBy2Groups}
\alias{plotBy2Groups}
\title{Separate and plot data by 2 groups}
\usage{
plotBy2Groups(
  dat,
  grp,
  grp2 = NULL,
  col = NULL,
  pch = NULL,
  tit = NULL,
  cex = 2,
  lwd = 0.5,
  lty = 2,
  yLab = NULL,
  cexLab = NULL,
  sepLines = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(numeric) main data (may contain \code{NA})}

\item{grp}{(character or factor) grouping of columns of 'dat', eg replicate association}

\item{grp2}{(character or factor) aadditional/secondary grouping of columns of 'dat'}

\item{col}{(character or integer) use custom colors, see also \code{\link[graphics]{par}}}

\item{pch}{(integer) symbol to mark group-center  (see also \code{\link[graphics]{par}})}

\item{tit}{(character) custom title}

\item{cex}{(numeric) expansion factor for text (see also \code{\link[graphics]{par}})}

\item{lwd}{(integer) line-width  (see also \code{\link[graphics]{par}})}

\item{lty}{(integer) line-type  (see also \code{\link[graphics]{par}})}

\item{yLab}{(character) custom y-axis label}

\item{cexLab}{(numeric) expansion factor for labels: 1st value for main groups (\code{grp}, eg genotypes), 2nd for detailed text (\code{grp2}, eg animal IDs) (see also \code{\link[graphics]{par}})}

\item{sepLines}{(logical) optional drawing of horizontal lines aiming to separate groups (in analogy to support vectors)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list with \code{$annot}, \code{$abund} for initial/raw abundance values and \code{$quant} with final normalized quantitations, or returns data.frame with annot and quant if \code{separateAnnot=FALSE}
}
\description{
Plot series of data as membership of 2 different grouping vectors (eg by grp=patient and grp2=age-group).
}
\examples{
set.seed(2020); rand1 <- round(runif(12),2) +rep(1:3,each=4)
plotBy2Groups(rand1, gl(2,6,labels=LETTERS[5:6]), gl(4,3,labels=letters[1:4]))
 
}
\seealso{
\code{\link[utils]{read.table}}, \code{\link[wrMisc]{normalizeThis}})
}
